<?php
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(\Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = \Illuminate\Http\Request::capture()
);

use App\Models\Warehouse\OutgoingTransaction;
use App\Models\Warehouse\OutgoingFulfillment;

echo "=== MATERIAL REQUEST DETAILS - UPDATED TERMINOLOGY ===\n\n";

// Test the updated logic with "released" terminology
$id = 1; // Material request ID

// Get transaction with relationships
$transaction = OutgoingTransaction::with([
    'project',
    'requester',
    'approver',
    'items.item'
])->findOrFail($id);

// Get fulfillment data
$fulfillments = OutgoingFulfillment::where('outgoing_transaction_id', $id)
    ->get()
    ->groupBy('item_id');

echo "Transaction: {$transaction->material_request_number} ({$transaction->status})\n";
echo "Project: " . ($transaction->project ? $transaction->project->project_name : 'N/A') . "\n";
echo "Requested by: " . ($transaction->requester ? $transaction->requester->name : 'N/A') . "\n\n";

echo "Items Detail (UPDATED TERMINOLOGY):\n";
$totalRequested = 0;
$totalReleased = 0;
$totalRemaining = 0;

foreach ($transaction->items as $item) {
    // Calculate released quantity from all fulfillment records
    $releasedQty = 0;
    if (isset($fulfillments[$item->item_id])) {
        $releasedQty = $fulfillments[$item->item_id]->sum('quantity_fulfilled');
    }

    // Calculate remaining quantity
    $remainingQty = max(0, $item->quantity_requested - $releasedQty);

    echo "- {$item->item->item_code}: {$item->item->item_description}\n";
    echo "  Requested: {$item->quantity_requested}\n";
    echo "  Released (old field): {$item->quantity_released}\n";
    echo "  Released (calculated): {$releasedQty}\n";
    echo "  Remaining: {$remainingQty}\n";

    // Show release breakdown
    if (isset($fulfillments[$item->item_id])) {
        echo "  Release breakdown:\n";
        foreach ($fulfillments[$item->item_id] as $fulfillment) {
            echo "    - {$fulfillment->quantity_fulfilled} via {$fulfillment->fulfillment_type}\n";
        }
    }
    echo "\n";

    $totalRequested += $item->quantity_requested;
    $totalReleased += $releasedQty;
    $totalRemaining += $remainingQty;
}

// Calculate overall status
$displayStatus = $transaction->status;
if ($totalReleased > 0) {
    if ($totalRemaining > 0) {
        $displayStatus = "Partially Released ({$totalReleased}/{$totalRequested})";
    } else {
        $displayStatus = "Fully Released";
    }
}

$releasePercentage = $totalRequested > 0 ? round(($totalReleased / $totalRequested) * 100, 1) : 0;

echo "=== SUMMARY (UPDATED TERMINOLOGY) ===\n";
echo "Original Status: {$transaction->status}\n";
echo "Display Status: {$displayStatus}\n";
echo "Total Requested: {$totalRequested}\n";
echo "Total Released: {$totalReleased}\n";
echo "Total Remaining: {$totalRemaining}\n";
echo "Release Percentage: {$releasePercentage}%\n\n";

echo "=== TERMINOLOGY UPDATED ===\n";
echo "✅ 'Fulfillment' → 'Released'\n";
echo "✅ 'Fulfilled' → 'Released'\n";
echo "✅ 'Fulfillment Details' → 'Release Details'\n";
echo "✅ 'Fulfillment Percentage' → 'Release Percentage'\n";
echo "✅ 'Partially Fulfilled' → 'Partially Released'\n";
echo "✅ 'Fully Fulfilled' → 'Fully Released'\n";