<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Site Returns Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            font-size: 18px;
            color: #333;
        }
        .header .subtitle {
            margin: 5px 0 0 0;
            color: #666;
            font-size: 12px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: left;
            vertical-align: top;
        }
        th {
            background-color: #f8f9fa;
            font-weight: bold;
            font-size: 10px;
        }
        td {
            font-size: 9px;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .status-passed {
            background-color: #d4edda;
            color: #155724;
            padding: 2px 5px;
            border-radius: 3px;
        }
        .status-pending {
            background-color: #fff3cd;
            color: #856404;
            padding: 2px 5px;
            border-radius: 3px;
        }
        .status-failed {
            background-color: #f8d7da;
            color: #721c24;
            padding: 2px 5px;
            border-radius: 3px;
        }
        .status-conditional {
            background-color: #cce5ff;
            color: #004085;
            padding: 2px 5px;
            border-radius: 3px;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
        .summary {
            margin-bottom: 20px;
            padding: 10px;
            background-color: #e9ecef;
            border-radius: 5px;
        }
        .summary-grid {
            width: 100%;
        }
        .summary-grid td {
            border: none;
            text-align: center;
            width: 33%;
        }
        .summary-label {
            font-size: 10px;
            color: #666;
            margin-bottom: 2px;
        }
        .summary-value {
            font-size: 14px;
            font-weight: bold;
            color: #333;
        }
        .no-print {
            margin-bottom: 20px;
            text-align: center;
        }
        .no-print button {
            padding: 10px 20px;
            font-size: 14px;
            cursor: pointer;
            margin: 0 5px;
        }
        .btn-print {
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 4px;
        }
        .btn-back {
            background-color: #6c757d;
            color: white;
            border: none;
            border-radius: 4px;
        }
        @media print {
            .no-print {
                display: none;
            }
            body {
                padding: 0;
            }
            @page {
                size: landscape;
                margin: 10mm;
            }
        }
    </style>
</head>
<body>
    <div class="no-print">
        <button class="btn-print" onclick="window.print()">Print / Save as PDF</button>
        <button class="btn-back" onclick="window.history.back()">Back to Report</button>
    </div>

    <div class="header">
        <h1>Site Returns Report</h1>
        <p class="subtitle">Generated on <?php echo e($generated_at); ?></p>
    </div>

    <div class="summary">
        <table class="summary-grid">
            <tr>
                <td>
                    <div class="summary-label">Total Returns</div>
                    <div class="summary-value"><?php echo e(number_format($items->count())); ?></div>
                </td>
                <td>
                    <div class="summary-label">Total Quantity</div>
                    <div class="summary-value"><?php echo e(number_format($total_quantity, 2)); ?></div>
                </td>
                <td>
                    <div class="summary-label">Total Value</div>
                    <div class="summary-value">AED <?php echo e(number_format($total_value, 2)); ?></div>
                </td>
            </tr>
        </table>
    </div>

    <table>
        <thead>
            <tr>
                <th style="width: 10%;">Reference</th>
                <th style="width: 8%;">Type</th>
                <th style="width: 12%;">Project</th>
                <th style="width: 10%;">Division</th>
                <th style="width: 10%;">Item Code</th>
                <th style="width: 18%;">Description</th>
                <th style="width: 7%;" class="text-right">Qty</th>
                <th style="width: 8%;" class="text-right">Unit Price</th>
                <th style="width: 8%;" class="text-right">Total</th>
                <th style="width: 9%;" class="text-center">Status</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($item->reference_number ?? '-'); ?></td>
                    <td><?php echo e($item->reference_type ?? '-'); ?></td>
                    <td><?php echo e(Str::limit($item->project_name ?? '-', 15)); ?></td>
                    <td><?php echo e(Str::limit($item->division ?? '-', 12)); ?></td>
                    <td><?php echo e($item->item_code); ?></td>
                    <td><?php echo e(Str::limit($item->item_description, 25)); ?></td>
                    <td class="text-right"><?php echo e(number_format($item->quantity, 2)); ?></td>
                    <td class="text-right"><?php echo e(number_format($item->unit_price, 2)); ?></td>
                    <td class="text-right"><?php echo e(number_format($item->total_price, 2)); ?></td>
                    <td class="text-center">
                        <span class="status-<?php echo e($item->quality_status ?? 'pending'); ?>">
                            <?php echo e(ucfirst($item->quality_status ?? 'pending')); ?>

                        </span>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="10" class="text-center">No return records found</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div class="footer">
        <p>KCG Inventory Management System - Site Returns Report</p>
        <p>This report contains <?php echo e(number_format($items->count())); ?> returns with a total value of AED <?php echo e(number_format($total_value, 2)); ?></p>
    </div>
</body>
</html>
<?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/reports/pdf/returns.blade.php ENDPATH**/ ?>