<?php $__env->startSection('title', 'Incoming Operation Details'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('warehouse.incoming-operations.index')); ?>">Incoming Operations</a></li>
    <li class="breadcrumb-item active">Operation #<?php echo e($operation->operation_number); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Operation #<?php echo e($operation->operation_number); ?></h3>
            <p class="text-muted mb-0" style="font-size: 13px;"><?php echo e($operation->operation_type_label); ?> - <?php echo e($operation->status); ?></p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <?php if($operation->status !== 'completed'): ?>
                <a href="<?php echo e(route('warehouse.incoming-operations.edit', $operation)); ?>" class="btn btn-sm btn-primary">
                    <i class="material-icons mr-1" style="font-size: 16px;">edit</i>
                    Edit
                </a>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Operation Details Card -->
    <div class="card mb-3">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">info</i>
                Operation Details
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="25%"><strong>Operation Number:</strong></td>
                            <td><?php echo e($operation->operation_number); ?></td>
                        </tr>
                        <tr>
                            <td width="25%"><strong>Operation Type:</strong></td>
                            <td><?php echo e($operation->operation_type_label); ?></td>
                        </tr>
                        <tr>
                            <td width="25%"><strong>Operation Date:</strong></td>
                            <td><?php echo e($operation->operation_date->format('d M, Y')); ?></td>
                        </tr>
                        <tr>
                            <td width="25%"><strong>Status:</strong></td>
                            <td><span class="badge <?php echo e($operation->status_badge_class); ?>"><?php echo e(ucfirst($operation->status)); ?></span></td>
                        </tr>
                        <?php if($operation->supplier): ?>
                        <tr>
                            <td width="25%"><strong>Supplier:</strong></td>
                            <td><?php echo e($operation->supplier->name); ?></td>
                        </tr>
                        <?php endif; ?>
                        <?php if($operation->operation_type === 'site_return' && $operation->materialRequest): ?>
                        <tr>
                            <td width="25%"><strong>MR Reference:</strong></td>
                            <td>
                                <span class="badge badge-info">
                                    <?php echo e($operation->materialRequest->material_request_number ?: 'MR-' . str_pad($operation->material_request_id, 6, '0', STR_PAD_LEFT)); ?>

                                </span>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <?php if($operation->project): ?>
                        <tr>
                            <td width="20%"><strong>Project:</strong></td>
                            <td>
                                <strong><?php echo e($operation->project->project_name); ?></strong>
                                <?php if($operation->project->project_number): ?>
                                    <br><small class="text-muted"><?php echo e($operation->project->project_number); ?></small>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endif; ?>
                        <tr>
                            <td width="20%"><strong>Division:</strong></td>
                            <td>
                                <?php if($operation->division_id && $operation->division): ?>
                                    <span class="badge badge-outline-primary"><?php echo e($operation->division->division_name); ?></span>
                                    <?php if($operation->division->division_code): ?>
                                        <small class="text-muted ml-1">(<?php echo e($operation->division->division_code); ?>)</small>
                                    <?php endif; ?>
                                <?php elseif($operation->project && $operation->project->projectDivision): ?>
                                    <span class="badge badge-outline-primary"><?php echo e($operation->project->projectDivision->division_name); ?></span>
                                    <?php if($operation->project->projectDivision->division_code): ?>
                                        <small class="text-muted ml-1">(<?php echo e($operation->project->projectDivision->division_code); ?>)</small>
                                    <?php endif; ?>
                                <?php elseif($operation->getAttributes()['division'] ?? null): ?>
                                    <?php
                                        // Handle legacy division field (stored as string ID)
                                        $legacyDivision = \App\Models\Warehouse\ProjectDivision::find($operation->getAttributes()['division']);
                                    ?>
                                    <?php if($legacyDivision): ?>
                                        <span class="badge badge-outline-primary"><?php echo e($legacyDivision->division_name); ?></span>
                                        <?php if($legacyDivision->division_code): ?>
                                            <small class="text-muted ml-1">(<?php echo e($legacyDivision->division_code); ?>)</small>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <span class="text-muted"><?php echo e($operation->getAttributes()['division']); ?></span>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <span class="text-muted">No Division</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php if($operation->delivery_file): ?>
                        <tr>
                            <td><strong>Delivery Document:</strong></td>
                            <td>
                                <a href="<?php echo e(asset($operation->delivery_file)); ?>"
                                   target="_blank"
                                   class="btn btn-sm btn-outline-success">
                                    <i class="material-icons mr-1" style="font-size: 16px;">attachment</i>
                                    View Uploaded File
                                </a>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </table>
                </div>
            </div>

            <?php if($operation->notes): ?>
            <div class="row mt-3">
                <div class="col-12">
                    <strong>Notes:</strong>
                    <p class="text-muted mb-0"><?php echo e($operation->notes); ?></p>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Items Card -->
    <div class="card mb-3">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">inventory</i>
                Items (<?php echo e($operation->items->count()); ?>)
            </h6>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-sm mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th>Item</th>
                            <th>Quantity</th>
                            <th>Batch</th>
                            <th>Production Date</th>
                            <th>Expiry Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $operation->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <strong><?php echo e($item->item->item_description ?? 'Unknown Item'); ?></strong><br>
                                <small class="text-muted"><?php echo e($item->item->item_code ?? 'NO-CODE'); ?></small>
                            </td>
                            <td><?php echo e(number_format($item->quantity_delivered, 2)); ?> <?php echo e($item->item->unit_of_measure ?? 'units'); ?></td>
                            <td><?php echo e($item->batch_number ?: '-'); ?></td>
                            <td><?php echo e($item->production_date ? $item->production_date->format('d M, Y') : '-'); ?></td>
                            <td><?php echo e($item->expiry_date ? $item->expiry_date->format('d M, Y') : '-'); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="text-center text-muted">No items found</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Receiving Information Card -->
    <div class="card">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">person</i>
                Receiving Information
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Received By:</strong></td>
                            <td><?php echo e($operation->receiver->name ?? 'Unknown'); ?></td>
                        </tr>
                        <tr>
                            <td><strong>Received By Name:</strong></td>
                            <td><?php echo e($operation->received_by_name ?: '-'); ?></td>
                        </tr>
                        <tr>
                            <td><strong>Created At:</strong></td>
                            <td><?php echo e($operation->created_at->format('d M, Y H:i')); ?></td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Total Amount:</strong></td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <span class="dirham-symbol text-dark mr-1" style="width: 16px; height: 16px; display: inline-flex; align-items: center;">
                                        <svg viewBox="0 0 1000 870" width="16" height="16" style="fill: currentColor;">
                                            <path d="m88.3 1c0.4 0.6 2.6 3.3 4.7 5.9 15.3 18.2 26.8 47.8 33 85.1 4.1 24.5 4.3 32.2 4.3 125.6v87h-41.8c-38.2 0-42.6-0.2-50.1-1.7-11.8-2.5-24-9.2-32.2-17.8-6.5-6.9-6.3-7.3-5.9 13.6 0.5 17.3 0.7 19.2 3.2 28.6 4 14.9 9.5 26 17.8 35.9 11.3 13.6 22.8 21.2 39.2 26.3 3.5 1 10.9 1.4 37.1 1.6l32.7 0.5v43.3 43.4l-46.1-0.3-46.3-0.3-8-3.2c-9.5-3.8-13.8-6.6-23.1-14.9l-6.8-6.1 0.4 19.1c0.5 17.7 0.6 19.7 3.1 28.7 8.7 31.8 29.7 54.5 57.4 61.9 6.9 1.9 9.6 2 38.5 2.4l30.9 0.4v89.6c0 54.1-0.3 94-0.8 100.8-0.5 6.2-2.1 17.8-3.5 25.9-6.5 37.3-18.2 65.4-35 83.6l-3.4 3.7h169.1c101.1 0 176.7-0.4 187.8-0.9 19.5-1 63-5.3 72.8-7.4 3.1-0.6 8.9-1.5 12.7-2.1 8.1-1.2 21.5-4 40.8-8.9 27.2-6.8 52-15.3 76.3-26.1 7.6-3.4 29.4-14.5 35.2-18 3.1-1.8 6.8-4 8.2-4.7 3.9-2.1 10.4-6.3 19.9-13.1 4.7-3.4 9.4-6.7 10.4-7.4 4.2-2.8 18.7-14.9 25.3-21 25.1-23.1 46.1-48.8 62.4-76.3 2.3-4 5.3-9 6.6-11.1 3.3-5.6 16.9-33.6 18.2-37.8 0.6-1.9 1.4-3.9 1.8-4.3 2.6-3.4 17.6-50.6 19.4-60.9 0.6-3.3 0.9-3.8 3.4-4.3 1.6-0.3 24.9-0.3 51.8-0.1 53.8 0.4 53.8 0.4 65.7 5.9 6.7 3.1 8.7 4.5 16.1 11.2 9.7 8.7 8.8 10.1 8.2-11.7-0.4-12.8-0.9-20.7-1.8-23.9-3.4-12.3-4.2-14.9-7.2-21.1-9.8-21.4-26.2-36.7-47.2-44l-8.2-3-33.4-0.4-33.3-0.5 0.4-11.7c0.4-15.4 0.4-45.9-0.1-61.6l-0.4-12.6 44.6-0.2c38.2-0.2 45.3 0 49.5 1.1 12.6 3.5 21.1 8.3 31.5 17.8l5.8 5.4v-14.8c0-17.6-0.9-25.4-4.5-37-7.1-23.5-21.1-41-41.1-51.8-13-7-13.8-7.2-58.5-7.5-26.2-0.2-39.9-0.6-40.6-1.2-0.6-0.6-1.1-1.6-1.1-2.4 0-0.8-1.5-7.1-3.5-13.9-23.4-82.7-67.1-148.4-131-197.1-8.7-6.7-30-20.8-38.6-25.6-3.3-1.9-6.9-3.9-7.8-4.5-4.2-2.3-28.3-14.1-34.3-16.6-3.6-1.6-8.3-3.6-10.4-4.4-35.3-15.3-94.5-29.8-139.7-34.3-7.4-0.7-17.2-1.8-21.7-2.2-20.4-2.3-48.7-2.6-209.4-2.6-135.8 0-169.9 0.3-169.4 1zm330.7 43.3c33.8 2 54.6 4.6 78.9 10.5 74.2 17.6 126.4 54.8 164.3 117 3.5 5.8 18.3 36 20.5 42.1 10.5 28.3 15.6 45.1 20.1 67.3 1.1 5.4 2.6 12.6 3.3 16 0.7 3.3 1 6.4 0.7 6.7-0.5 0.4-100.9 0.6-223.3 0.5l-222.5-0.2-0.3-128.5c-0.1-70.6 0-129.3 0.3-130.4l0.4-1.9h71.1c39 0 78 0.4 86.5 0.9zm297.5 350.3c0.7 4.3 0.7 77.3 0 80.9l-0.6 2.7-227.5-0.2-227.4-0.3-0.2-42.4c-0.2-23.3 0-42.7 0.2-43.1 0.3-0.5 97.2-0.8 227.7-0.8h227.2zm-10.2 171.7c0.5 1.5-1.9 13.8-6.8 33.8-5.6 22.5-13.2 45.2-20.9 62-3.8 8.6-13.3 27.2-15.6 30.7-1.1 1.6-4.3 6.7-7.1 11.2-18 28.2-43.7 53.9-73 72.9-10.7 6.8-32.7 18.4-38.6 20.2-1.2 0.3-2.5 0.9-3 1.3-0.7 0.6-9.8 4-20.4 7.8-19.5 6.9-56.6 14.4-86.4 17.5-19.3 1.9-22.4 2-96.7 2h-76.9v-129.7-129.8l220.9-0.4c121.5-0.2 221.6-0.5 222.4-0.7 0.9-0.1 1.8 0.5 2.1 1.2z"></path>
                                        </svg>
                                    </span>
                                    <div>
                                        <span class="font-weight-medium text-dark"><?php echo e(number_format($operation->total_amount_aed ?? 0, 2)); ?></span>
                                        <?php if($operation->currency !== 'AED'): ?>
                                            <br><small class="text-muted"><?php echo e($operation->currency); ?> <?php echo e(number_format($operation->total_amount ?? 0, 2)); ?></small>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php if($operation->lpo_number): ?>
                        <tr>
                            <td><strong>LPO Number:</strong></td>
                            <td><?php echo e($operation->lpo_number); ?></td>
                        </tr>
                        <?php endif; ?>
                        <?php if($operation->currency !== 'AED'): ?>
                        <tr>
                            <td><strong>Currency:</strong></td>
                            <td><?php echo e($operation->currency); ?> (Rate: <?php echo e(number_format($operation->exchange_rate, 4)); ?>)</td>
                        </tr>
                        <?php endif; ?>
                    </table>
                    <?php if($operation->lpo_number): ?>
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>LPO Number:</strong></td>
                            <td><?php echo e($operation->lpo_number); ?></td>
                        </tr>
                        <?php if($operation->delivery_note_number): ?>
                        <tr>
                            <td><strong>Delivery Note:</strong></td>
                            <td><?php echo e($operation->delivery_note_number); ?></td>
                        </tr>
                        <?php endif; ?>
                    </table>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <style>
        .card-title {
            font-size: 16px;
            font-weight: 600;
            color: #495057;
        }

        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            font-size: 13px;
        }

        .table td {
            vertical-align: middle;
            font-size: 13px;
        }

        .table-borderless td {
            border: none;
            padding: 0.25rem 0.5rem;
        }

        .badge {
            font-size: 11px;
            padding: 4px 8px;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/incoming-operations/show.blade.php ENDPATH**/ ?>