<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>FOC Summary Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            font-size: 18px;
            color: #333;
        }
        .header .subtitle {
            margin: 5px 0 0 0;
            color: #666;
            font-size: 12px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            vertical-align: top;
        }
        th {
            background-color: #f8f9fa;
            font-weight: bold;
            font-size: 11px;
        }
        td {
            font-size: 10px;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
        .summary {
            margin-bottom: 20px;
            padding: 10px;
            background-color: #e9ecef;
            border-radius: 5px;
        }
        .summary-grid {
            width: 100%;
        }
        .summary-grid td {
            border: none;
            text-align: center;
            width: 20%;
        }
        .summary-label {
            font-size: 10px;
            color: #666;
            margin-bottom: 2px;
        }
        .summary-value {
            font-size: 14px;
            font-weight: bold;
            color: #333;
        }
        .no-print {
            margin-bottom: 20px;
            text-align: center;
        }
        .no-print button {
            padding: 10px 20px;
            font-size: 14px;
            cursor: pointer;
            margin: 0 5px;
        }
        .btn-print {
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 4px;
        }
        .btn-back {
            background-color: #6c757d;
            color: white;
            border: none;
            border-radius: 4px;
        }
        @media print {
            .no-print {
                display: none;
            }
            body {
                padding: 0;
            }
            @page {
                size: landscape;
                margin: 10mm;
            }
        }
    </style>
</head>
<body>
    <div class="no-print">
        <button class="btn-print" onclick="window.print()">Print / Save as PDF</button>
        <button class="btn-back" onclick="window.history.back()">Back to Report</button>
    </div>

    <div class="header">
        <h1>FOC Summary Report</h1>
        <p class="subtitle">Generated on <?php echo e($generated_at); ?></p>
    </div>

    <div class="summary">
        <table class="summary-grid">
            <tr>
                <td>
                    <div class="summary-label">Total Items</div>
                    <div class="summary-value"><?php echo e(number_format(count($items))); ?></div>
                </td>
                <td>
                    <div class="summary-label">Total Records</div>
                    <div class="summary-value"><?php echo e(number_format($stats['total_records'])); ?></div>
                </td>
                <td>
                    <div class="summary-label">Total Quantity</div>
                    <div class="summary-value"><?php echo e(number_format($stats['total_quantity'], 2)); ?></div>
                </td>
                <td>
                    <div class="summary-label">Total Cost</div>
                    <div class="summary-value">AED <?php echo e(number_format($stats['total_cost'], 2)); ?></div>
                </td>
                <td>
                    <div class="summary-label">Total Loss</div>
                    <div class="summary-value">AED <?php echo e(number_format($stats['total_loss'], 2)); ?></div>
                </td>
            </tr>
        </table>
    </div>

    <table>
        <thead>
            <tr>
                <th style="width: 12%;">Item Code</th>
                <th style="width: 25%;">Description</th>
                <th style="width: 12%;">Category</th>
                <th style="width: 8%;">Unit</th>
                <th style="width: 8%;" class="text-right">Records</th>
                <th style="width: 10%;" class="text-right">Total Qty</th>
                <th style="width: 12%;" class="text-right">Total Cost (AED)</th>
                <th style="width: 12%;" class="text-right">Total Loss (AED)</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($item->item_code ?? '-'); ?></td>
                    <td><?php echo e(Str::limit($item->item_description ?? '-', 35)); ?></td>
                    <td><?php echo e($item->category_name ?? '-'); ?></td>
                    <td><?php echo e($item->unit ?? '-'); ?></td>
                    <td class="text-right"><?php echo e(number_format($item->record_count ?? 0)); ?></td>
                    <td class="text-right"><?php echo e(number_format($item->total_quantity ?? 0, 2)); ?></td>
                    <td class="text-right"><?php echo e(number_format($item->total_cost ?? 0, 2)); ?></td>
                    <td class="text-right"><?php echo e(number_format($item->loss_amount ?? 0, 2)); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="8" class="text-center">No damaged items found</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div class="footer">
        <p>KCG Inventory Management System - FOC Summary Report</p>
        <p>This report contains <?php echo e(number_format(count($items))); ?> items with a total loss of AED <?php echo e(number_format($stats['total_loss'], 2)); ?></p>
    </div>
</body>
</html>
<?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/reports/pdf/damaged-items.blade.php ENDPATH**/ ?>