<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Stock on Project Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            font-size: 18px;
            color: #333;
        }
        .header .subtitle {
            margin: 5px 0 0 0;
            color: #666;
            font-size: 12px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            vertical-align: top;
        }
        th {
            background-color: #f8f9fa;
            font-weight: bold;
            font-size: 11px;
        }
        td {
            font-size: 10px;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .status-active {
            background-color: #d4edda;
            color: #155724;
            padding: 2px 5px;
            border-radius: 3px;
        }
        .status-completed {
            background-color: #cce5ff;
            color: #004085;
            padding: 2px 5px;
            border-radius: 3px;
        }
        .status-on_hold {
            background-color: #fff3cd;
            color: #856404;
            padding: 2px 5px;
            border-radius: 3px;
        }
        .status-cancelled {
            background-color: #f8d7da;
            color: #721c24;
            padding: 2px 5px;
            border-radius: 3px;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
        .summary {
            margin-bottom: 20px;
            padding: 10px;
            background-color: #e9ecef;
            border-radius: 5px;
        }
        .summary-grid {
            width: 100%;
        }
        .summary-grid td {
            border: none;
            text-align: center;
            width: 25%;
        }
        .summary-label {
            font-size: 10px;
            color: #666;
            margin-bottom: 2px;
        }
        .summary-value {
            font-size: 14px;
            font-weight: bold;
            color: #333;
        }
        .no-print {
            margin-bottom: 20px;
            text-align: center;
        }
        .no-print button {
            padding: 10px 20px;
            font-size: 14px;
            cursor: pointer;
            margin: 0 5px;
        }
        .btn-print {
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 4px;
        }
        .btn-back {
            background-color: #6c757d;
            color: white;
            border: none;
            border-radius: 4px;
        }
        @media print {
            .no-print {
                display: none;
            }
            body {
                padding: 0;
            }
            @page {
                size: landscape;
                margin: 10mm;
            }
        }
    </style>
</head>
<body>
    <div class="no-print">
        <button class="btn-print" onclick="window.print()">Print / Save as PDF</button>
        <button class="btn-back" onclick="window.history.back()">Back to Report</button>
    </div>

    <div class="header">
        <h1>Stock on Project Report</h1>
        <p class="subtitle">Generated on <?php echo e($generated_at); ?></p>
    </div>

    <div class="summary">
        <table class="summary-grid">
            <tr>
                <td>
                    <div class="summary-label">Total Projects</div>
                    <div class="summary-value"><?php echo e(number_format($stats['total_projects'])); ?></div>
                </td>
                <td>
                    <div class="summary-label">Unique Items</div>
                    <div class="summary-value"><?php echo e(number_format($stats['total_unique_items'])); ?></div>
                </td>
                <td>
                    <div class="summary-label">Total Stock Qty</div>
                    <div class="summary-value"><?php echo e(number_format($stats['total_stock'], 2)); ?></div>
                </td>
                <td>
                    <div class="summary-label">Total Value</div>
                    <div class="summary-value">AED <?php echo e(number_format($stats['total_value'], 2)); ?></div>
                </td>
            </tr>
        </table>
    </div>

    <table>
        <thead>
            <tr>
                <th style="width: 30%;">Project Name</th>
                <th style="width: 15%;">Project Number</th>
                <th style="width: 12%;" class="text-center">Status</th>
                <th style="width: 13%;" class="text-right">Unique Items</th>
                <th style="width: 15%;" class="text-right">Total Stock Qty</th>
                <th style="width: 15%;" class="text-right">Total Value (AED)</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($project->project_name ?? '-'); ?></td>
                    <td><?php echo e($project->project_number ?? '-'); ?></td>
                    <td class="text-center">
                        <span class="status-<?php echo e($project->status ?? 'active'); ?>">
                            <?php echo e(ucfirst(str_replace('_', ' ', $project->status ?? 'N/A'))); ?>

                        </span>
                    </td>
                    <td class="text-right"><?php echo e(number_format($project->unique_items ?? 0)); ?></td>
                    <td class="text-right"><?php echo e(number_format($project->total_stock ?? 0, 2)); ?></td>
                    <td class="text-right"><?php echo e(number_format($project->total_value ?? 0, 2)); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="text-center">No projects found</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div class="footer">
        <p>KCG Inventory Management System - Stock on Project Report</p>
        <p>This report contains <?php echo e(number_format($stats['total_projects'])); ?> projects with a total value of AED <?php echo e(number_format($stats['total_value'], 2)); ?></p>
    </div>
</body>
</html>
<?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/reports/pdf/stock-on-project.blade.php ENDPATH**/ ?>