<?php $__env->startSection('title', 'Material Request Report'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('warehouse.reports.index')); ?>">Reports</a></li>
    <li class="breadcrumb-item active">Material Request</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title-left">
        <h3 class="mb-1">Material Request Report</h3>
        <p class="text-muted mb-0" style="font-size: 13px;">Material request tracking and fulfillment status</p>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Statistics Cards -->
    <div class="row mb-4 warehouse-stats-row">
        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Requests','value' => $outgoingRequests->total(),'icon' => 'assignment','color' => 'primary','subtitle' => 'Material requests created']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Requests','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($outgoingRequests->total()),'icon' => 'assignment','color' => 'primary','subtitle' => 'Material requests created']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Requested','value' => number_format($outgoingRequests->getCollection()->sum('total_requested'), 2),'icon' => 'inventory_2','color' => 'info','subtitle' => 'Total requested from warehouse']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Requested','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(number_format($outgoingRequests->getCollection()->sum('total_requested'), 2)),'icon' => 'inventory_2','color' => 'info','subtitle' => 'Total requested from warehouse']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Released','value' => number_format($outgoingRequests->getCollection()->sum('total_released'), 2),'icon' => 'outbound','color' => 'success','subtitle' => 'Total fulfilled from requests']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Released','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(number_format($outgoingRequests->getCollection()->sum('total_released'), 2)),'icon' => 'outbound','color' => 'success','subtitle' => 'Total fulfilled from requests']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Pending Balance','value' => number_format($outgoingRequests->getCollection()->sum('total_balance'), 2),'icon' => 'pending_actions','color' => 'warning','subtitle' => 'Total pending fulfillment']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Pending Balance','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(number_format($outgoingRequests->getCollection()->sum('total_balance'), 2)),'icon' => 'pending_actions','color' => 'warning','subtitle' => 'Total pending fulfillment']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
    </div>

    <!-- Filters Panel -->
    <div class="card mb-4 warehouse-filters-panel">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="material-icons align-middle mr-2">filter_list</i>
                Filters
            </h5>
        </div>
        <div class="card-body">
            <form id="filterForm" class="warehouse-filter-form" method="GET" action="<?php echo e(route('warehouse.reports.outgoing')); ?>">
                <div class="row">
                    <div class="col-md-2 mb-3">
                        <label class="form-label">Search</label>
                        <input type="text" name="search" value="<?php echo e(request('search')); ?>" class="form-control" 
                               placeholder="MR number, project">
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Project</label>
                        <select name="project_id" class="form-control warehouse-select2" data-placeholder="All Projects">
                            <option value="">All Projects</option>
                            <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($project->id); ?>" <?php echo e(request('project_id') == $project->id ? 'selected' : ''); ?>>
                                    <?php echo e($project->project_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Division</label>
                        <select name="division_id" class="form-control warehouse-select2" data-placeholder="All Divisions">
                            <option value="">All Divisions</option>
                            <?php $__currentLoopData = $divisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($division->id); ?>" <?php echo e(request('division_id') == $division->id ? 'selected' : ''); ?>>
                                    <?php echo e($division->division_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-control warehouse-select2" data-placeholder="All Statuses">
                            <option value="">All Statuses</option>
                            <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($status); ?>" <?php echo e(request('status') == $status ? 'selected' : ''); ?>>
                                    <?php echo e(ucfirst(str_replace('_', ' ', $status))); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Fulfillment</label>
                        <select name="fulfillment_status" class="form-control warehouse-select2" data-placeholder="All Fulfillment">
                            <option value="">All Fulfillment</option>
                            <?php $__currentLoopData = $fulfillmentStatuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fulfillmentStatus): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($fulfillmentStatus); ?>" <?php echo e(request('fulfillment_status') == $fulfillmentStatus ? 'selected' : ''); ?>>
                                    <?php echo e(ucfirst($fulfillmentStatus)); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">&nbsp;</label>
                        <button type="submit" class="btn btn-primary btn-block">
                            <i class="material-icons" style="font-size: 18px; vertical-align: middle;">search</i>
                            Apply
                        </button>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-2 mb-3">
                        <label class="form-label">Date From</label>
                        <input type="date" name="date_from" value="<?php echo e(request('date_from')); ?>" class="form-control warehouse-datepicker">
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Date To</label>
                        <input type="date" name="date_to" value="<?php echo e(request('date_to')); ?>" class="form-control warehouse-datepicker">
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Export Buttons -->
    <div class="row warehouse-export-buttons">
        <div class="col-12 text-right">
            <button class="btn btn-success warehouse-export-btn" data-export="excel">
                <i class="material-icons" style="font-size: 18px; vertical-align: middle;">download</i>
                Export Excel
            </button>
            <button class="btn btn-info warehouse-export-btn" data-export="pdf">
                <i class="material-icons" style="font-size: 18px; vertical-align: middle;">picture_as_pdf</i>
                Export PDF
            </button>
            <button class="btn btn-secondary warehouse-export-btn" data-action="print">
                <i class="material-icons" style="font-size: 18px; vertical-align: middle;">print</i>
                Print
            </button>
        </div>
    </div>

    <!-- Material Request Report Table -->
    <div class="card">
        <div class="card-header warehouse-report-header">
            <h5 class="mb-0 warehouse-report-title">
                <i class="material-icons align-middle mr-2">assignment_turned_in</i>
                Material Request Report (<?php echo e($outgoingRequests->total()); ?> total requests)
            </h5>
        </div>
        <div class="card-body p-0">
            <div class="warehouse-table-container">
                <!-- Loading Overlay -->
                <div class="warehouse-loading-overlay" id="tableLoadingOverlay">
                    <div class="warehouse-loading-content">
                        <div class="text-center">
                            <div class="spinner-border text-primary" role="status">
                                <span class="sr-only">Loading...</span>
                            </div>
                            <div class="mt-2">Loading request data...</div>
                        </div>
                    </div>
                </div>

                <!-- Table -->
                <div class="warehouse-table-wrapper">
                    <table class="table table-hover mb-0 warehouse-table">
                        <thead class="thead-light">
                            <tr>
                                <th style="min-width: 150px;">Request Number</th>
                                <th style="min-width: 100px;">Request Date</th>
                                <th style="min-width: 180px;">Project</th>
                                <th style="min-width: 120px;">Division</th>
                                <th style="min-width: 150px;">Requested By</th>
                                <th style="min-width: 80px;" class="text-center">Items</th>
                                <th style="min-width: 100px;" class="text-right">Requested Qty</th>
                                <th style="min-width: 100px;" class="text-right">Released Qty</th>
                                <th style="min-width: 100px;" class="text-right">Pending Qty</th>
                                <th style="min-width: 120px;">Dispatch Methods</th>
                                <th style="min-width: 120px;" class="text-center">Fulfillment Status</th>
                                <th style="min-width: 80px;" class="text-center">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $outgoingRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td class="warehouse-cell-nowrap">
                                        <?php echo e($request->material_request_number ?: 'MR-' . str_pad($request->id, 6, '0', STR_PAD_LEFT)); ?>

                                    </td>
                                    <td class="warehouse-cell-date">
                                        <?php echo e($request->transaction_date->format('d M Y')); ?>

                                    </td>
                                    <td><?php echo e(Str::limit($request->project->project_name ?? 'No Project', 25)); ?></td>
                                    <td>
                                        <span class="badge warehouse-badge warehouse-status-secondary">
                                            <?php echo e($request->division->division_name ??
                                               ($request->project->projectDivision->division_name ?? 'Main')); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e($request->requester->name ?? 'Not Specified'); ?></td>
                                    <td class="text-center">
                                        <span class="badge warehouse-badge warehouse-status-info"><?php echo e($request->items_count); ?> items</span>
                                    </td>
                                    <td class="text-right warehouse-cell-number">
                                        <strong><?php echo e(number_format($request->total_requested, 2)); ?></strong>
                                    </td>
                                    <td class="text-right warehouse-cell-number">
                                        <strong class="text-success"><?php echo e(number_format($request->total_released, 2)); ?></strong>
                                    </td>
                                    <td class="text-right warehouse-cell-number">
                                        <strong class="<?php echo e($request->total_balance > 0 ? 'text-warning' : 'text-success'); ?>">
                                            <?php echo e(number_format($request->total_balance, 2)); ?>

                                        </strong>
                                    </td>
                                    <td>
                                        <small><?php echo e($request->dispatch_methods_text ?? 'Pending'); ?></small>
                                    </td>
                                    <td class="warehouse-cell-status">
                                        <?php if($request->fulfillment_status === 'completed'): ?>
                                            <span class="badge warehouse-badge warehouse-status-success">Completed</span>
                                        <?php elseif($request->fulfillment_status === 'partial'): ?>
                                            <span class="badge warehouse-badge warehouse-status-warning">Partial</span>
                                        <?php else: ?>
                                            <span class="badge warehouse-badge warehouse-status-info">Pending</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center">
                                        <a href="<?php echo e(route('warehouse.reports.outgoing.request-details', $request->id)); ?>" 
                                           class="btn btn-sm btn-outline-primary warehouse-action-btn">
                                            <i class="material-icons">visibility</i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="12" class="warehouse-empty-state">
                                        <i class="material-icons">assignment</i>
                                        <h5>No Material Requests Found</h5>
                                        <p class="text-muted">No requests match your current filters.</p>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        
        <?php if($outgoingRequests->hasPages()): ?>
            <div class="card-footer">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        Showing <?php echo e($outgoingRequests->firstItem()); ?> to <?php echo e($outgoingRequests->lastItem()); ?> 
                        of <?php echo e($outgoingRequests->total()); ?> requests
                    </div>
                    <div>
                        <nav class="warehouse-pagination">
                            <?php echo e($outgoingRequests->links('pagination::bootstrap-4')); ?>

                        </nav>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <link href="<?php echo e(asset('admin-assets/css/warehouse-reports.css')); ?>" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />
    <style>
        .select2-container--bootstrap-5 .select2-selection {
            min-height: 38px;
            border: 1px solid #ced4da;
        }
        .select2-container--bootstrap-5 .select2-selection--single .select2-selection__rendered {
            line-height: 36px;
        }
        .select2-container--bootstrap-5 .select2-selection--single .select2-selection__arrow {
            height: 36px;
        }
        .select2-container {
            width: 100% !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="<?php echo e(asset('admin-assets/js/warehouse-reports.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            // Initialize Select2 for filter dropdowns
            $('.warehouse-select2').select2({
                theme: 'bootstrap-5',
                allowClear: true,
                placeholder: function() {
                    return $(this).data('placeholder') || 'Select...';
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/reports/outgoing.blade.php ENDPATH**/ ?>