<?php $__env->startSection('title', 'Reference Allocations - ' . $item->item_description); ?>

<?php $__env->startPush('styles'); ?>
    <link href="<?php echo e(asset('admin-assets/css/warehouse-reports.css')); ?>" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<?php $__env->stopPush(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item">Reports</li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('warehouse.reports.stock-on-project')); ?>">Stock on Project</a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('warehouse.reports.stock-on-project.details', $project->id)); ?>"><?php echo e($project->project_name); ?></a></li>
    <li class="breadcrumb-item active">Reference Allocations</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Reference Allocations</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">
                Item: <?php echo e($item->item_description); ?> (<?php echo e($item->item_code); ?>) |
                Project: <?php echo e($project->project_name); ?>

            </p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <a href="<?php echo e(route('warehouse.reports.stock-on-project.details', $project->id)); ?>" class="btn btn-sm btn-secondary mr-2">
                <i class="material-icons mr-1" style="font-size: 16px;">arrow_back</i>
                Back to Stock Details
            </a>
            <button type="button" onclick="exportAllocations()" class="btn btn-sm btn-success mr-2" title="Export to Excel">
                <i class="material-icons mr-1" style="font-size: 16px;">file_download</i>
                Export
            </button>
            <button type="button" onclick="printAllocations()" class="btn btn-sm btn-info" title="Print Report">
                <i class="material-icons mr-1" style="font-size: 16px;">print</i>
                Print
            </button>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Statistics Cards -->
    <div class="row mb-4 warehouse-stats-row">
        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total References','value' => $references->count(),'icon' => 'receipt_long','color' => 'primary','subtitle' => 'Reference allocations']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total References','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($references->count()),'icon' => 'receipt_long','color' => 'primary','subtitle' => 'Reference allocations']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Released Quantity','value' => number_format($totals['total_released'], 2),'icon' => 'output','color' => 'info','subtitle' => 'Total quantity released']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Released Quantity','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(number_format($totals['total_released'], 2)),'icon' => 'output','color' => 'info','subtitle' => 'Total quantity released']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Net Available','value' => number_format($totals['total_net'], 2),'icon' => 'check_circle','color' => 'success','subtitle' => 'Net available quantity']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Net Available','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(number_format($totals['total_net'], 2)),'icon' => 'check_circle','color' => 'success','subtitle' => 'Net available quantity']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Value','value' => 'AED ' . number_format($totals['total_value'], 2),'icon' => 'attach_money','color' => 'warning','subtitle' => 'Total allocation value']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Value','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('AED ' . number_format($totals['total_value'], 2)),'icon' => 'attach_money','color' => 'warning','subtitle' => 'Total allocation value']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
    </div>

    <!-- Item Information Card -->
    <div class="card mb-4">
        <div class="card-header bg-primary text-white">
            <h6 class="mb-0">
                <i class="material-icons mr-2">inventory_2</i>
                Item Information
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-4">
                    <div class="d-flex align-items-center mb-2">
                        <strong class="mr-2">Item Code:</strong>
                        <span class="badge badge-light"><?php echo e($item->item_code); ?></span>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="d-flex align-items-center mb-2">
                        <strong class="mr-2">Description:</strong>
                        <span><?php echo e($item->item_description); ?></span>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="d-flex align-items-center mb-2">
                        <strong class="mr-2">Unit:</strong>
                        <span class="badge badge-secondary"><?php echo e($item->unit_of_measure); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters Panel -->
    <div class="card mb-4 warehouse-filters-panel">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="material-icons align-middle mr-2">filter_list</i>
                Filters
            </h5>
        </div>
        <div class="card-body">
            <form id="filterForm" class="warehouse-filter-form" method="GET" action="<?php echo e(route('warehouse.reports.item-reference-allocations', [$project->id, $item->id])); ?>">
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Reference Type</label>
                        <select name="type" class="form-control warehouse-select2">
                            <option value="">All Types</option>
                            <option value="Material Request" <?php echo e(request('type') == 'Material Request' ? 'selected' : ''); ?>>Material Request</option>
                            <option value="Direct Delivery" <?php echo e(request('type') == 'Direct Delivery' ? 'selected' : ''); ?>>Direct Delivery</option>
                            <option value="Material Transfer" <?php echo e(request('type') == 'Material Transfer' ? 'selected' : ''); ?>>Material Transfer</option>
                        </select>
                    </div>

                    <div class="col-md-3 mb-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-control warehouse-select2">
                            <option value="">All Statuses</option>
                            <option value="successful" <?php echo e(request('status') == 'successful' ? 'selected' : ''); ?>>Successful</option>
                            <option value="delivered" <?php echo e(request('status') == 'delivered' ? 'selected' : ''); ?>>Delivered</option>
                            <option value="approved" <?php echo e(request('status') == 'approved' ? 'selected' : ''); ?>>Approved</option>
                            <option value="received" <?php echo e(request('status') == 'received' ? 'selected' : ''); ?>>Received</option>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Date From</label>
                        <input type="date" name="date_from" value="<?php echo e(request('date_from')); ?>" class="form-control">
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Date To</label>
                        <input type="date" name="date_to" value="<?php echo e(request('date_to')); ?>" class="form-control">
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">&nbsp;</label>
                        <button type="submit" class="btn btn-primary btn-block">
                            <i class="material-icons" style="font-size: 18px; vertical-align: middle;">search</i>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Reference Allocations Table -->
    <div class="card warehouse-report-card">
        <div class="card-header">
            <h6 class="card-title mb-0">
                <i class="material-icons mr-2">receipt_long</i>
                Reference Allocations Detail
                <?php if($references->count() > 0): ?>
                    <span class="badge badge-primary ml-2"><?php echo e($references->count()); ?> References</span>
                <?php endif; ?>
            </h6>
        </div>
        <div class="card-body">
            <?php if($references->count() > 0): ?>
                <div class="warehouse-table-container">
                    <div class="warehouse-loading-overlay" id="tableLoadingOverlay" style="display: none;">
                        <div class="warehouse-loading-content">
                            <div class="warehouse-loading-spinner"></div>
                            <div class="warehouse-loading-text">Loading reference allocations...</div>
                        </div>
                    </div>
                    <div class="warehouse-table-wrapper">
                        <table class="table table-hover mb-0 warehouse-table">
                            <thead class="warehouse-table-header">
                                <tr>
                                    <th class="warehouse-cell-nowrap">Type</th>
                                    <th class="warehouse-cell-nowrap">Reference #</th>
                                    <th class="warehouse-cell-date">Date</th>
                                    <th class="warehouse-cell-text">Requested By / Supplier</th>
                                    <th class="warehouse-cell-text">Division / From</th>
                                    <th class="warehouse-cell-status">Status</th>
                                    <th class="warehouse-cell-number text-right">Released</th>
                                    <th class="warehouse-cell-number text-right">Returned</th>
                                    <th class="warehouse-cell-number text-right">Transferred</th>
                                    <th class="warehouse-cell-number text-right">Net Qty</th>
                                    <th class="warehouse-cell-currency text-right">Value (AED)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $references; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ref): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $typeClass = $ref['type'] === 'Material Request' ? 'badge-primary' :
                                                    ($ref['type'] === 'Direct Delivery' ? 'badge-success' : 'badge-info');
                                        $statusClass = in_array(strtolower($ref['status']), ['successful', 'delivered', 'approved', 'received']) ?
                                                       'badge-success' : 'badge-warning';
                                    ?>
                                    <tr class="warehouse-table-row">
                                        <td class="warehouse-cell-nowrap">
                                            <span class="badge <?php echo e($typeClass); ?>"><?php echo e($ref['type']); ?></span>
                                        </td>
                                        <td class="warehouse-cell-nowrap">
                                            <strong><?php echo e($ref['reference_number']); ?></strong>
                                        </td>
                                        <td class="warehouse-cell-date"><?php echo e($ref['date']); ?></td>
                                        <td class="warehouse-cell-text"><?php echo e($ref['requested_by']); ?></td>
                                        <td class="warehouse-cell-text"><?php echo e($ref['division']); ?></td>
                                        <td class="warehouse-cell-status">
                                            <span class="badge <?php echo e($statusClass); ?>"><?php echo e($ref['status']); ?></span>
                                        </td>
                                        <td class="warehouse-cell-number text-right">
                                            <?php echo e(number_format($ref['quantity_released'], 2)); ?>

                                        </td>
                                        <td class="warehouse-cell-number text-right text-warning">
                                            <?php echo e(number_format($ref['quantity_returned'], 2)); ?>

                                        </td>
                                        <td class="warehouse-cell-number text-right text-info">
                                            <?php echo e(number_format($ref['quantity_transferred'], 2)); ?>

                                        </td>
                                        <td class="warehouse-cell-number text-right text-success">
                                            <strong><?php echo e(number_format($ref['net_quantity'], 2)); ?></strong>
                                        </td>
                                        <td class="warehouse-cell-currency text-right">
                                            AED <?php echo e(number_format($ref['total_value'], 2)); ?>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot class="warehouse-table-footer">
                                <tr>
                                    <th colspan="6" class="warehouse-cell-total"><strong>Total</strong></th>
                                    <th class="warehouse-cell-number text-right">
                                        <strong><?php echo e(number_format($totals['total_released'], 2)); ?></strong>
                                    </th>
                                    <th class="warehouse-cell-number text-right text-warning">
                                        <strong><?php echo e(number_format($totals['total_returned'], 2)); ?></strong>
                                    </th>
                                    <th class="warehouse-cell-number text-right text-info">
                                        <strong><?php echo e(number_format($totals['total_transferred'], 2)); ?></strong>
                                    </th>
                                    <th class="warehouse-cell-number text-right text-success">
                                        <strong><?php echo e(number_format($totals['total_net'], 2)); ?></strong>
                                    </th>
                                    <th class="warehouse-cell-currency text-right">
                                        <strong>AED <?php echo e(number_format($totals['total_value'], 2)); ?></strong>
                                    </th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            <?php else: ?>
                <div class="warehouse-empty-state">
                    <div class="warehouse-empty-icon">
                        <i class="material-icons">inbox</i>
                    </div>
                    <h5 class="warehouse-empty-title">No Reference Allocations Found</h5>
                    <p class="warehouse-empty-description">
                        No reference allocations found for this item in the selected project.<br>
                        This means the item hasn't been delivered or transferred to this project.
                    </p>
                    <div class="warehouse-empty-actions">
                        <a href="<?php echo e(route('warehouse.reports.stock-on-project.details', $project->id)); ?>" class="btn btn-primary">
                            <i class="material-icons mr-1">arrow_back</i>
                            Back to Stock Details
                        </a>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Additional Information -->
    <?php if($references->count() > 0): ?>
    <div class="card mt-4">
        <div class="card-header">
            <h6 class="card-title mb-0">
                <i class="material-icons mr-2">info</i>
                Allocation Summary
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <h6 class="text-muted mb-3">Reference Type Distribution</h6>
                    <?php
                        $materialRequests = $references->where('type', 'Material Request')->count();
                        $directDeliveries = $references->where('type', 'Direct Delivery')->count();
                        $materialTransfers = $references->where('type', 'Material Transfer')->count();
                    ?>
                    <div class="mb-2">
                        <span class="badge badge-primary mr-2">Material Requests: <?php echo e($materialRequests); ?></span>
                    </div>
                    <div class="mb-2">
                        <span class="badge badge-success mr-2">Direct Deliveries: <?php echo e($directDeliveries); ?></span>
                    </div>
                    <div class="mb-2">
                        <span class="badge badge-info mr-2">Material Transfers: <?php echo e($materialTransfers); ?></span>
                    </div>
                </div>
                <div class="col-md-6">
                    <h6 class="text-muted mb-3">Key Metrics</h6>
                    <div class="mb-2">
                        <strong>Total References:</strong> <?php echo e($references->count()); ?>

                    </div>
                    <div class="mb-2">
                        <strong>Total Value:</strong> AED <?php echo e(number_format($totals['total_value'], 2)); ?>

                    </div>
                    <div class="mb-2">
                        <strong>Return Rate:</strong>
                        <?php if($totals['total_released'] > 0): ?>
                            <?php echo e(number_format(($totals['total_returned'] / $totals['total_released']) * 100, 2)); ?>%
                        <?php else: ?>
                            0%
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('admin-assets/js/warehouse-reports.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            // Initialize warehouse table functionality
            if (typeof initializeWarehouseTable === 'function') {
                initializeWarehouseTable();
            }
        });

        function exportAllocations() {
            showLoadingOverlay();

            // Simulate export process
            setTimeout(function() {
                hideLoadingOverlay();
                alert('Export functionality will be implemented soon.');
            }, 1000);
        }

        function printAllocations() {
            window.print();
        }

        function showLoadingOverlay() {
            $('#tableLoadingOverlay').show();
        }

        function hideLoadingOverlay() {
            $('#tableLoadingOverlay').hide();
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/reports/item-reference-allocations.blade.php ENDPATH**/ ?>