@extends('layouts.admin-simple')

@section('title', $supplier->name)

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('warehouse.suppliers.index') }}">Suppliers</a></li>
    <li class="breadcrumb-item active">{{ $supplier->name }}</li>
@endsection

@section('page-title')
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">{{ $supplier->name }}</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">{{ $supplier->supplier_code }} • Supplier Details and Performance</p>
        </div>
        @can('warehouse.suppliers.edit')
        <div class="page-actions-right d-flex align-items-center">
            <a href="{{ route('warehouse.suppliers.index') }}" class="btn btn-sm btn-secondary mr-2" title="Back to suppliers list">
                <i class="material-icons mr-1" style="font-size: 16px;">arrow_back</i>
                Back
            </a>
            <button type="button" onclick="showEditSupplierModal({{ $supplier->id }})" class="btn btn-sm btn-primary" title="Edit supplier">
                <i class="material-icons mr-1" style="font-size: 16px;">edit</i>
                Edit Supplier
            </button>
        </div>
        @endcan
    </div>
@endsection

@section('content')
    <div class="row">
        <!-- Main Information -->
        <div class="col-lg-8 mb-4">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <i class="material-icons align-middle mr-2">business</i>
                        Supplier Information
                    </h5>
                    <div class="d-flex align-items-center">
                        @php
                            $statusColors = [
                                'active' => 'success',
                                'inactive' => 'secondary',
                                'suspended' => 'danger'
                            ];
                            $statusColor = $statusColors[$supplier->status] ?? 'secondary';
                        @endphp
                        <span class="badge badge-{{ $statusColor }} mr-2">{{ ucfirst($supplier->status) }}</span>
                        <span class="text-muted">{{ $supplier->supplier_code }}</span>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6 class="font-weight-bold text-primary mb-3">Contact Information</h6>
                            <dl class="row">
                                <dt class="col-sm-4">Contact Person:</dt>
                                <dd class="col-sm-8">{{ $supplier->contact_person ?: '-' }}</dd>
                                
                                <dt class="col-sm-4">Email:</dt>
                                <dd class="col-sm-8">
                                    @if($supplier->email)
                                        <a href="mailto:{{ $supplier->email }}" class="text-primary">{{ $supplier->email }}</a>
                                    @else
                                        -
                                    @endif
                                </dd>
                                
                                <dt class="col-sm-4">Phone:</dt>
                                <dd class="col-sm-8">{{ $supplier->phone ?: '-' }}</dd>
                                
                                <dt class="col-sm-4">Mobile:</dt>
                                <dd class="col-sm-8">{{ $supplier->mobile ?: '-' }}</dd>
                                
                                @if($supplier->website)
                                <dt class="col-sm-4">Website:</dt>
                                <dd class="col-sm-8">
                                    <a href="{{ $supplier->website }}" target="_blank" class="text-primary">{{ $supplier->website }}</a>
                                </dd>
                                @endif
                            </dl>
                        </div>
                        
                        <div class="col-md-6">
                            <h6 class="font-weight-bold text-primary mb-3">Address</h6>
                            <p class="mb-4">{{ $supplier->full_address ?: 'No address provided' }}</p>
                            
                            <h6 class="font-weight-bold text-primary mb-3">Financial Information</h6>
                            <dl class="row">
                                <dt class="col-sm-5">Payment Terms:</dt>
                                <dd class="col-sm-7">{{ $supplier->payment_terms ?: '-' }}</dd>
                                
                                <dt class="col-sm-5">Credit Limit:</dt>
                                <dd class="col-sm-7">
                                    @if($supplier->credit_limit)
                                        {{ $supplier->currency }} {{ number_format($supplier->credit_limit, 2) }}
                                    @else
                                        -
                                    @endif
                                </dd>
                                
                                <dt class="col-sm-5">Currency:</dt>
                                <dd class="col-sm-7">{{ $supplier->currency }}</dd>
                                
                                @if($supplier->tax_number)
                                <dt class="col-sm-5">Tax Number:</dt>
                                <dd class="col-sm-7">{{ $supplier->tax_number }}</dd>
                                @endif
                            </dl>
                        </div>
                    </div>
                    
                    @if($supplier->bank_name || $supplier->bank_account)
                    <hr class="my-4">
                    <h6 class="font-weight-bold text-primary mb-3">Banking Information</h6>
                    <div class="row">
                        <div class="col-md-6">
                            <dl class="row">
                                <dt class="col-sm-4">Bank Name:</dt>
                                <dd class="col-sm-8">{{ $supplier->bank_name ?: '-' }}</dd>
                            </dl>
                        </div>
                        <div class="col-md-6">
                            <dl class="row">
                                <dt class="col-sm-4">Account:</dt>
                                <dd class="col-sm-8">{{ $supplier->bank_account ?: '-' }}</dd>
                            </dl>
                        </div>
                    </div>
                    @endif
                    
                    @if($supplier->notes)
                    <hr class="my-4">
                    <h6 class="font-weight-bold text-primary mb-3">Notes</h6>
                    <p class="text-muted">{{ $supplier->notes }}</p>
                    @endif
                    
                    <hr class="my-4">
                    <div class="row">
                        <div class="col-md-6">
                            <small class="text-muted">
                                <strong>Created:</strong> {{ $supplier->created_at->format('M d, Y H:i') }} by {{ $supplier->createdBy?->name ?? 'System' }}
                            </small>
                        </div>
                        <div class="col-md-6">
                            <small class="text-muted">
                                <strong>Last Updated:</strong> {{ $supplier->updated_at->format('M d, Y H:i') }}
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Performance Card -->
        <div class="col-lg-4 mb-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">
                        <i class="material-icons align-middle mr-2">trending_up</i>
                        Performance Overview
                    </h5>
                </div>
                <div class="card-body text-center">
                    <!-- Overall Rating -->
                    <div class="mb-4">
                        <h3 class="display-4 font-weight-bold text-primary">{{ $supplier->formatted_rating }}</h3>
                        <div class="mb-2">
                            @for($i = 1; $i <= 5; $i++)
                                @if($i <= floor($supplier->rating))
                                    <i class="material-icons text-warning" style="font-size: 20px;">star</i>
                                @else
                                    <i class="material-icons text-muted" style="font-size: 20px;">star_border</i>
                                @endif
                            @endfor
                        </div>
                        <small class="text-muted">Overall Rating</small>
                    </div>
                    
                    <!-- Performance Score -->
                    <div class="mb-4">
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <span class="font-weight-bold">Performance Score</span>
                            <span class="font-weight-bold {{ $supplier->performance_score >= 80 ? 'text-success' : ($supplier->performance_score >= 60 ? 'text-warning' : 'text-danger') }}">
                                {{ number_format($supplier->performance_score, 1) }}%
                            </span>
                        </div>
                        <div class="progress" style="height: 8px;">
                            <div class="progress-bar {{ $supplier->performance_score >= 80 ? 'bg-success' : ($supplier->performance_score >= 60 ? 'bg-warning' : 'bg-danger') }}"
                                 style="width: {{ $supplier->performance_score }}%"></div>
                        </div>
                    </div>
                    
                    <!-- Quick Stats -->
                    <div class="border-top pt-3">
                        <div class="row text-center">
                            <div class="col-4">
                                <h6 class="font-weight-bold mb-0">{{ $performanceData['total_orders'] ?? 0 }}</h6>
                                <small class="text-muted">Orders</small>
                            </div>
                            <div class="col-4">
                                <h6 class="font-weight-bold mb-0">${{ number_format($performanceData['total_value'] ?? 0, 0) }}</h6>
                                <small class="text-muted">Total Value</small>
                            </div>
                            <div class="col-4">
                                <h6 class="font-weight-bold mb-0">${{ number_format($performanceData['average_order_value'] ?? 0, 0) }}</h6>
                                <small class="text-muted">Avg Order</small>
                            </div>
                        </div>
                    </div>
                    
                    @can('warehouse.suppliers.edit')
                    <div class="border-top pt-3 mt-3">
                        <button type="button" onclick="showRatingModal()" class="btn btn-outline-primary btn-block">
                            <i class="material-icons mr-1" style="font-size: 16px;">star</i>
                            Update Rating
                        </button>
                    </div>
                    @endcan
                </div>
            </div>
        </div>
    </div>
    
    <!-- Performance Details -->
    @if(!empty($performanceData['rating_breakdown']))
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="material-icons align-middle mr-2">assessment</i>
                Performance Breakdown
            </h5>
        </div>
        <div class="card-body">
            <div class="row text-center">
                @foreach($performanceData['rating_breakdown'] as $category => $score)
                <div class="col-md-3 col-sm-6 mb-3">
                    <h4 class="font-weight-bold text-primary">{{ number_format($score, 1) }}</h4>
                    <p class="text-muted mb-2">{{ ucfirst($category) }}</p>
                    <div class="progress" style="height: 6px;">
                        <div class="progress-bar bg-primary" style="width: {{ ($score/5)*100 }}%"></div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    @endif
    
    <!-- Recent Activity -->
    @if(!empty($performanceData['recent_activity']) && $performanceData['recent_activity']->count() > 0)
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="material-icons align-middle mr-2">history</i>
                Recent Activity
            </h5>
        </div>
        <div class="card-body p-0">
            <div class="list-group list-group-flush">
                @foreach($performanceData['recent_activity'] as $activity)
                <div class="list-group-item d-flex justify-content-between align-items-start">
                    <div>
                        <h6 class="mb-1">Transaction #{{ $activity->id }}</h6>
                        <small class="text-muted">{{ $activity->created_at->format('M d, Y H:i') }}</small>
                    </div>
                    <div class="text-right">
                        <span class="font-weight-bold">${{ number_format($activity->total_amount ?? 0, 2) }}</span>
                        <br>
                        <small class="text-muted">{{ $activity->status }}</small>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    @endif
@endsection

@section('modals')
    <!-- Edit Supplier Modal (reuse from index) -->
    <div class="modal fade" id="editSupplierModal" tabindex="-1" role="dialog" aria-labelledby="editSupplierModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editSupplierModalLabel">
                        <i class="material-icons mr-2">edit</i>
                        Edit Supplier
                    </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="editSupplierForm" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Supplier Name <span class="text-danger">*</span></label>
                                <input type="text" name="name" id="edit_name" class="form-control" required placeholder="Enter supplier name">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Supplier Code</label>
                                <input type="text" name="supplier_code" id="edit_supplier_code" class="form-control" placeholder="Enter supplier code">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Contact Person</label>
                                <input type="text" name="contact_person" id="edit_contact_person" class="form-control" placeholder="Enter contact person">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Email</label>
                                <input type="email" name="email" id="edit_email" class="form-control" placeholder="Enter email address">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Phone</label>
                                <input type="text" name="phone" id="edit_phone" class="form-control" placeholder="Enter phone number">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Mobile</label>
                                <input type="text" name="mobile" id="edit_mobile" class="form-control" placeholder="Enter mobile number">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label class="form-label">Address</label>
                                <textarea name="address" id="edit_address" class="form-control" rows="2" placeholder="Enter address"></textarea>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">City</label>
                                <input type="text" name="city" id="edit_city" class="form-control" placeholder="Enter city">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Country</label>
                                <input type="text" name="country" id="edit_country" class="form-control" placeholder="Enter country">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Status <span class="text-danger">*</span></label>
                                <select name="status" id="edit_status" class="form-control" required>
                                    <option value="active">Active</option>
                                    <option value="inactive">Inactive</option>
                                    <option value="suspended">Suspended</option>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Payment Terms</label>
                                <select name="payment_terms" id="edit_payment_terms" class="form-control">
                                    <option value="">Select Payment Terms</option>
                                    <option value="Net 15">Net 15</option>
                                    <option value="Net 30">Net 30</option>
                                    <option value="Net 45">Net 45</option>
                                    <option value="Net 60">Net 60</option>
                                    <option value="Cash on Delivery">Cash on Delivery</option>
                                    <option value="Advance Payment">Advance Payment</option>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Rating</label>
                                <select name="rating" id="edit_rating" class="form-control">
                                    <option value="">Select Rating</option>
                                    <option value="1">1 Star</option>
                                    <option value="2">2 Stars</option>
                                    <option value="3">3 Stars</option>
                                    <option value="4">4 Stars</option>
                                    <option value="5">5 Stars</option>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label class="form-label">Notes</label>
                                <textarea name="notes" id="edit_notes" class="form-control" rows="3" placeholder="Enter any notes about the supplier"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">
                            <i class="material-icons mr-1" style="font-size: 16px;">cancel</i>
                            Cancel
                        </button>
                        <button type="submit" class="btn btn-primary">
                            <i class="material-icons mr-1" style="font-size: 16px;">save</i>
                            Update Supplier
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- Rating Update Modal -->
    <div class="modal fade" id="ratingModal" tabindex="-1" role="dialog" aria-labelledby="ratingModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="ratingModalLabel">
                        <i class="material-icons mr-2">star</i>
                        Update Supplier Rating
                    </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="ratingForm">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label class="form-label">Rating (0-5)</label>
                            <input type="number" name="rating" min="0" max="5" step="0.1" value="{{ $supplier->rating }}"
                                   class="form-control" placeholder="Enter rating from 0 to 5">
                        </div>
                        <div class="form-group">
                            <label class="form-label">Notes</label>
                            <textarea name="notes" rows="3" class="form-control" placeholder="Enter any notes about the rating">{{ $supplier->notes }}</textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">
                            <i class="material-icons mr-1" style="font-size: 16px;">cancel</i>
                            Cancel
                        </button>
                        <button type="button" onclick="updateRating()" class="btn btn-primary">
                            <i class="material-icons mr-1" style="font-size: 16px;">star</i>
                            Update Rating
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        // Reuse the edit functionality from the index page
        function showEditSupplierModal(supplierId) {
            console.log('🔧 Opening edit modal for supplier ID:', supplierId);
            
            fetch(`{{ url('warehouse/suppliers') }}/${supplierId}/edit`, {
                method: 'GET',
                headers: {
                    'Accept': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    const supplier = data.data;
                    
                    // Populate form fields
                    document.getElementById('edit_name').value = supplier.name || '';
                    document.getElementById('edit_supplier_code').value = supplier.supplier_code || '';
                    document.getElementById('edit_contact_person').value = supplier.contact_person || '';
                    document.getElementById('edit_email').value = supplier.email || '';
                    document.getElementById('edit_phone').value = supplier.phone || '';
                    document.getElementById('edit_mobile').value = supplier.mobile || '';
                    document.getElementById('edit_address').value = supplier.address || '';
                    document.getElementById('edit_city').value = supplier.city || '';
                    document.getElementById('edit_country').value = supplier.country || '';
                    document.getElementById('edit_status').value = supplier.status || 'active';
                    document.getElementById('edit_payment_terms').value = supplier.payment_terms || '';
                    document.getElementById('edit_rating').value = supplier.rating || '';
                    document.getElementById('edit_notes').value = supplier.notes || '';
                    
                    // Set form action
                    document.getElementById('editSupplierForm').action = `{{ url('warehouse/suppliers') }}/${supplier.id}`;
                    
                    // Show modal
                    $('#editSupplierModal').modal('show');
                    console.log('✅ Edit modal opened successfully');
                } else {
                    alert('Error loading supplier data: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Error loading supplier data. Please try again.');
            });
        }
        
        function showRatingModal() {
            $('#ratingModal').modal('show');
        }

        function updateRating() {
            const formData = new FormData(document.getElementById('ratingForm'));

            fetch('{{ route("warehouse.suppliers.updateRating", $supplier) }}', {
                method: 'POST',
                body: formData,
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                $('#ratingModal').modal('hide');
                if (data.success) {
                    location.reload();
                } else {
                    alert(data.message || 'Error updating rating');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Error updating rating. Please try again.');
            });
        }
        
        // Handle edit form submission
        $(document).ready(function() {
            $('#editSupplierForm').on('submit', function(e) {
                e.preventDefault();
                
                const formData = new FormData(this);
                const supplierId = this.action.split('/').pop();
                
                fetch(this.action, {
                    method: 'POST',
                    body: formData,
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json'
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        $('#editSupplierModal').modal('hide');
                        location.reload();
                    } else {
                        alert('Error updating supplier: ' + data.message);
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Error updating supplier. Please try again.');
                });
            });
        });
    </script>
@endpush