@extends('layouts.admin-simple')

@section('title', 'Supplier Performance Report')

@section('breadcrumb')
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.reports.index') }}">Reports</a></li>
    <li class="breadcrumb-item active">Supplier Performance</li>
@endsection

@section('page-title')
    <div class="page-title-left">
        <h3 class="mb-1">Supplier Performance Report</h3>
        <p class="text-muted mb-0" style="font-size: 13px;">Analysis of supplier delivery and quality metrics</p>
    </div>
@endsection

@section('content')
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="material-icons align-middle mr-2">business</i>
                Supplier Performance Metrics
            </h5>
        </div>
        <div class="card-body">
            <p class="text-muted">This report provides insights into supplier performance, delivery times, and quality metrics.</p>

            <div class="alert alert-info">
                <i class="material-icons align-middle mr-2">info</i>
                This feature is under development. Supplier performance metrics will be available soon.
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
// Future implementation for supplier performance report functionality
</script>
@endpush