<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Material Requests Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            font-size: 18px;
            color: #333;
        }
        .header .subtitle {
            margin: 5px 0 0 0;
            color: #666;
            font-size: 12px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: left;
            vertical-align: top;
        }
        th {
            background-color: #f8f9fa;
            font-weight: bold;
            font-size: 10px;
        }
        td {
            font-size: 9px;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .status-completed {
            background-color: #d4edda;
            color: #155724;
            padding: 2px 5px;
            border-radius: 3px;
        }
        .status-pending {
            background-color: #fff3cd;
            color: #856404;
            padding: 2px 5px;
            border-radius: 3px;
        }
        .status-partial {
            background-color: #cce5ff;
            color: #004085;
            padding: 2px 5px;
            border-radius: 3px;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
        .summary {
            margin-bottom: 20px;
            padding: 10px;
            background-color: #e9ecef;
            border-radius: 5px;
        }
        .summary-grid {
            width: 100%;
        }
        .summary-grid td {
            border: none;
            text-align: center;
            width: 25%;
        }
        .summary-label {
            font-size: 10px;
            color: #666;
            margin-bottom: 2px;
        }
        .summary-value {
            font-size: 14px;
            font-weight: bold;
            color: #333;
        }
        .no-print {
            margin-bottom: 20px;
            text-align: center;
        }
        .no-print button {
            padding: 10px 20px;
            font-size: 14px;
            cursor: pointer;
            margin: 0 5px;
        }
        .btn-print {
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 4px;
        }
        .btn-back {
            background-color: #6c757d;
            color: white;
            border: none;
            border-radius: 4px;
        }
        @media print {
            .no-print {
                display: none;
            }
            body {
                padding: 0;
            }
            @page {
                size: landscape;
                margin: 10mm;
            }
        }
    </style>
</head>
<body>
    <div class="no-print">
        <button class="btn-print" onclick="window.print()">Print / Save as PDF</button>
        <button class="btn-back" onclick="window.history.back()">Back to Report</button>
    </div>

    <div class="header">
        <h1>Material Requests Report</h1>
        <p class="subtitle">Generated on {{ $generated_at }}</p>
    </div>

    <div class="summary">
        <table class="summary-grid">
            <tr>
                <td>
                    <div class="summary-label">Total Requests</div>
                    <div class="summary-value">{{ number_format($requests->count()) }}</div>
                </td>
                <td>
                    <div class="summary-label">Total Requested Qty</div>
                    <div class="summary-value">{{ number_format($total_requested, 2) }}</div>
                </td>
                <td>
                    <div class="summary-label">Total Released Qty</div>
                    <div class="summary-value">{{ number_format($total_released, 2) }}</div>
                </td>
                <td>
                    <div class="summary-label">Pending Balance</div>
                    <div class="summary-value">{{ number_format($total_requested - $total_released, 2) }}</div>
                </td>
            </tr>
        </table>
    </div>

    <table>
        <thead>
            <tr>
                <th style="width: 12%;">MR Number</th>
                <th style="width: 8%;">Date</th>
                <th style="width: 15%;">Project</th>
                <th style="width: 10%;">Division</th>
                <th style="width: 10%;">Type of Goods</th>
                <th style="width: 10%;">Requested By</th>
                <th style="width: 7%;" class="text-right">Requested</th>
                <th style="width: 7%;" class="text-right">Released</th>
                <th style="width: 7%;" class="text-right">Balance</th>
                <th style="width: 8%;" class="text-center">Fulfillment</th>
                <th style="width: 6%;" class="text-center">Status</th>
            </tr>
        </thead>
        <tbody>
            @forelse($requests as $request)
                @php
                    $divisionName = $request->division?->division_name ?? $request->project?->projectDivision?->division_name ?? '-';
                @endphp
                <tr>
                    <td>{{ $request->material_request_number ?? '-' }}</td>
                    <td>{{ $request->transaction_date ? \Carbon\Carbon::parse($request->transaction_date)->format('d M Y') : '-' }}</td>
                    <td>{{ Str::limit($request->project?->project_name ?? '-', 20) }}</td>
                    <td>{{ Str::limit($divisionName, 12) }}</td>
                    <td>{{ Str::limit($request->type_of_goods ?? '-', 12) }}</td>
                    <td>{{ Str::limit($request->requester?->name ?? '-', 12) }}</td>
                    <td class="text-right">{{ number_format($request->total_requested ?? 0, 2) }}</td>
                    <td class="text-right">{{ number_format($request->total_released ?? 0, 2) }}</td>
                    <td class="text-right">{{ number_format($request->total_balance ?? 0, 2) }}</td>
                    <td class="text-center">
                        <span class="status-{{ $request->fulfillment_status ?? 'pending' }}">
                            {{ ucfirst($request->fulfillment_status ?? 'pending') }}
                        </span>
                    </td>
                    <td class="text-center">{{ ucfirst($request->status ?? 'pending') }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="11" class="text-center">No material requests found</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="footer">
        <p>KCG Inventory Management System - Material Requests Report</p>
        <p>This report contains {{ number_format($requests->count()) }} material requests</p>
    </div>
</body>
</html>
