<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Division Deliveries Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            font-size: 18px;
            color: #333;
        }
        .header .subtitle {
            margin: 5px 0 0 0;
            color: #666;
            font-size: 12px;
        }
        .filters {
            margin-bottom: 20px;
            padding: 10px;
            background-color: #f8f9fa;
            border-radius: 5px;
        }
        .filters h3 {
            margin: 0 0 10px 0;
            font-size: 14px;
        }
        .filter-item {
            display: inline-block;
            margin-right: 20px;
            margin-bottom: 5px;
        }
        .filter-label {
            font-weight: bold;
            color: #333;
        }
        .filter-value {
            color: #666;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            vertical-align: top;
        }
        th {
            background-color: #f8f9fa;
            font-weight: bold;
            font-size: 11px;
        }
        td {
            font-size: 10px;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .utilization-high {
            background-color: #d4edda;
            color: #155724;
        }
        .utilization-medium {
            background-color: #fff3cd;
            color: #856404;
        }
        .utilization-low {
            background-color: #f8d7da;
            color: #721c24;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
        .summary {
            margin-bottom: 20px;
            padding: 10px;
            background-color: #e9ecef;
            border-radius: 5px;
        }
        .summary-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 10px;
        }
        .summary-item {
            text-align: center;
        }
        .summary-label {
            font-size: 10px;
            color: #666;
            margin-bottom: 2px;
        }
        .summary-value {
            font-size: 12px;
            font-weight: bold;
            color: #333;
        }
        .no-print {
            margin-bottom: 20px;
            text-align: center;
        }
        .no-print button {
            padding: 10px 20px;
            font-size: 14px;
            cursor: pointer;
            margin: 0 5px;
        }
        .btn-print {
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 4px;
        }
        .btn-back {
            background-color: #6c757d;
            color: white;
            border: none;
            border-radius: 4px;
        }
        @media print {
            .no-print {
                display: none;
            }
            body {
                padding: 0;
            }
            @page {
                size: landscape;
                margin: 10mm;
            }
        }
    </style>
</head>
<body>
    <div class="no-print">
        <button class="btn-print" onclick="window.print()">Print / Save as PDF</button>
        <button class="btn-back" onclick="window.history.back()">Back to Report</button>
    </div>

    <div class="header">
        <h1>Division Deliveries Report</h1>
        <p class="subtitle">Generated on {{ $generated_at }}</p>
    </div>

    @if($filters['division_id'] || $filters['category_id'] || $filters['search'])
    <div class="filters">
        <h3>Applied Filters:</h3>
        @if($filters['division_id'])
        <div class="filter-item">
            <span class="filter-label">Division:</span>
            <span class="filter-value">{{ \App\Models\Department::find($filters['division_id'])->name ?? 'Unknown' }}</span>
        </div>
        @endif
        @if($filters['category_id'])
        <div class="filter-item">
            <span class="filter-label">Category:</span>
            <span class="filter-value">{{ \App\Models\Warehouse\ItemCategory::find($filters['category_id'])->category_name ?? 'Unknown' }}</span>
        </div>
        @endif
        @if($filters['search'])
        <div class="filter-item">
            <span class="filter-label">Search:</span>
            <span class="filter-value">{{ $filters['search'] }}</span>
        </div>
        @endif
    </div>
    @endif

    <div class="summary">
        <div class="summary-grid">
            <div class="summary-item">
                <div class="summary-label">Total Items</div>
                <div class="summary-value">{{ number_format($deliveries->count()) }}</div>
            </div>
            <div class="summary-item">
                <div class="summary-label">Total Delivered</div>
                <div class="summary-value">{{ number_format($deliveries->sum('total_quantity_delivered'), 2) }}</div>
            </div>
            <div class="summary-item">
                <div class="summary-label">Total Value</div>
                <div class="summary-value">AED {{ number_format($deliveries->sum('total_value'), 2) }}</div>
            </div>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th style="width: 12%;">Item Code</th>
                <th style="width: 25%;">Description</th>
                <th style="width: 12%;">Division</th>
                <th style="width: 10%;" class="text-right">Total Delivered</th>
                <th style="width: 10%;" class="text-right">Available</th>
                <th style="width: 10%;" class="text-right">Total Issued</th>
                <th style="width: 8%;" class="text-center">Utilization %</th>
                <th style="width: 13%;" class="text-right">Total Value (AED)</th>
            </tr>
        </thead>
        <tbody>
            @forelse($deliveries as $delivery)
                @php
                    $utilizationRate = $delivery->total_quantity_delivered > 0
                        ? ($delivery->total_quantity_issued / $delivery->total_quantity_delivered) * 100
                        : 0;

                    $utilizationClass = '';
                    if ($utilizationRate >= 70) {
                        $utilizationClass = 'utilization-high';
                    } elseif ($utilizationRate >= 30) {
                        $utilizationClass = 'utilization-medium';
                    } else {
                        $utilizationClass = 'utilization-low';
                    }
                @endphp
                <tr>
                    <td>{{ $delivery->item->item_code }}</td>
                    <td>{{ $delivery->item->item_description }}</td>
                    <td>{{ $delivery->division->division_name }}</td>
                    <td class="text-right">{{ number_format($delivery->total_quantity_delivered, 2) }}</td>
                    <td class="text-right">{{ number_format($delivery->current_available_quantity, 2) }}</td>
                    <td class="text-right">{{ number_format($delivery->total_quantity_issued, 2) }}</td>
                    <td class="text-center {{ $utilizationClass }}">{{ number_format($utilizationRate, 1) }}%</td>
                    <td class="text-right">{{ number_format($delivery->total_value, 2) }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="8" class="text-center">No division deliveries found</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="footer">
        <p>KCG Inventory Management System - Division Deliveries Report</p>
        <p>This report contains {{ number_format($deliveries->count()) }} items with a total value of AED {{ number_format($deliveries->sum('total_value'), 2) }}</p>
    </div>
</body>
</html>