@extends('layouts.admin-simple')

@section('title', 'Material Details - ' . $item->item_code)

@section('breadcrumb')
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.reports.index') }}">Reports</a></li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.reports.materials') }}">Materials Report</a></li>
    <li class="breadcrumb-item active">{{ $item->item_code }}</li>
@endsection

@section('page-title')
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">{{ $item->item_code }} - Detailed Analysis</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">{{ $item->item_description }}</p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <a href="{{ route('warehouse.reports.materials') }}" class="btn btn-sm btn-outline-secondary mr-2">
                <i class="material-icons mr-1" style="font-size: 16px;">arrow_back</i>
                Back to Report
            </a>
            <button type="button" onclick="printMaterialDetails()" class="btn btn-sm btn-info">
                <i class="material-icons mr-1" style="font-size: 16px;">print</i>
                Print Details
            </button>
        </div>
    </div>
@endsection

@section('content')
    <!-- Material Summary -->
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">info</i>
                Material Information
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Material Code:</strong></td>
                            <td>{{ $item->item_code }}</td>
                        </tr>
                        <tr>
                            <td><strong>Description:</strong></td>
                            <td>{{ $item->item_description }}</td>
                        </tr>
                        <tr>
                            <td><strong>Category:</strong></td>
                            <td>{{ $item->category->category_name ?? 'Unknown' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Unit of Measure:</strong></td>
                            <td>{{ $item->unit_of_measure }}</td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Total Quantity:</strong></td>
                            <td><strong>{{ number_format($totalQuantity, 2) }} {{ $item->unit_of_measure }}</strong></td>
                        </tr>
                        <tr>
                            <td><strong>Total Value:</strong></td>
                            <td><strong>AED {{ number_format($totalValue, 2) }}</strong></td>
                        </tr>
                        <tr>
                            <td><strong>FOC Estimated Value:</strong></td>
                            <td><strong>AED {{ number_format($estimatedFocValue, 2) }}</strong></td>
                        </tr>
                        <tr>
                            <td><strong>Purchase History:</strong></td>
                            <td>{{ $pricingHistory->count() }} purchase operations</td>
                        </tr>
                        <tr>
                            <td><strong>Storage Locations:</strong></td>
                            <td>
                                Warehouse: {{ $warehouseInventory->groupBy('location')->count() }} divisions |
                                Projects: {{ $projectSummary->count() }} projects |
                                FOC: {{ $focSummary->count() }} sources
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Pricing History -->
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">attach_money</i>
                Purchase Price History ({{ $pricingHistory->count() }} records)
            </h6>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-sm mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th>Date</th>
                            <th>Operation</th>
                            <th>Supplier</th>
                            <th>Quantity</th>
                            <th>Unit Price (Original)</th>
                            <th>Unit Price (د.إ)</th>
                            <th>Total Value (د.إ)</th>
                            <th>Batch</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($pricingHistory as $purchase)
                            <tr>
                                <td>{{ $purchase->date->format('d M, Y') }}</td>
                                <td>
                                    <span class="badge badge-outline-primary">{{ $purchase->operation_number }}</span>
                                </td>
                                <td>{{ $purchase->supplier }}</td>
                                <td class="text-right">{{ number_format($purchase->quantity, 2) }}</td>
                                <td class="text-right">
                                    {{ $purchase->currency }} {{ number_format($purchase->original_unit_price, 2) }}
                                </td>
                                <td class="text-right">
                                    <strong>AED {{ number_format($purchase->unit_price, 2) }}</strong>
                                </td>
                                <td class="text-right">
                                    <strong>AED {{ number_format($purchase->total_price, 2) }}</strong>
                                </td>
                                <td>{{ $purchase->batch_number ?: '-' }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center py-3">
                                    <span class="text-muted">No purchase history found</span>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Project Summary -->
    @if($projectSummary->count() > 0)
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2 text-primary">business</i>
                Materials on Projects ({{ $projectSummary->count() }} projects)
            </h6>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-sm mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th>Project Name</th>
                            <th class="text-right">Available Quantity</th>
                            <th class="text-right">Allocated Quantity</th>
                            <th class="text-right">Available for Transfer</th>
                            <th class="text-right">Total Value</th>
                            <th class="text-center">Batches</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($projectSummary as $project)
                            <tr>
                                <td>
                                    <span class="badge badge-primary">{{ $project['project_name'] }}</span>
                                </td>
                                <td class="text-right">
                                    <strong>{{ number_format($project['total_quantity'], 2) }}</strong> {{ $item->unit_of_measure }}
                                </td>
                                <td class="text-right">
                                    <span class="text-warning">{{ number_format($project['allocated_quantity'], 2) }}</span> {{ $item->unit_of_measure }}
                                </td>
                                <td class="text-right">
                                    <span class="text-success">{{ number_format($project['available_for_transfer'], 2) }}</span> {{ $item->unit_of_measure }}
                                </td>
                                <td class="text-right">
                                    <strong>AED {{ number_format($project['total_value'], 2) }}</strong>
                                </td>
                                <td class="text-center">
                                    <span class="badge badge-secondary">{{ $project['batches_count'] }}</span>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    @endif

    <!-- FOC Summary -->
    @if($focSummary->count() > 0)
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2 text-warning">volunteer_activism</i>
                FOC Materials ({{ $focSummary->count() }} sources)
                <small class="ml-2 text-muted">Free of Charge</small>
            </h6>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-sm mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th>Source Project</th>
                            <th class="text-right">Available Quantity</th>
                            <th class="text-right">Reserved Quantity</th>
                            <th class="text-right">Net Available</th>
                            <th class="text-right">Estimated Value</th>
                            <th class="text-right">Recoverable Value</th>
                            <th class="text-center">Batches</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($focSummary as $foc)
                            <tr>
                                <td>
                                    <span class="badge badge-warning">{{ $foc['project_name'] }}</span>
                                </td>
                                <td class="text-right">
                                    <strong>{{ number_format($foc['total_quantity'], 2) }}</strong> {{ $item->unit_of_measure }}
                                </td>
                                <td class="text-right">
                                    <span class="text-info">{{ number_format($foc['reserved_quantity'], 2) }}</span> {{ $item->unit_of_measure }}
                                </td>
                                <td class="text-right">
                                    <span class="text-success">{{ number_format($foc['net_available'], 2) }}</span> {{ $item->unit_of_measure }}
                                </td>
                                <td class="text-right">
                                    <span class="text-muted">AED {{ number_format($foc['estimated_value'], 2) }}</span>
                                </td>
                                <td class="text-right">
                                    <strong class="text-success">AED {{ number_format($foc['recoverable_value'], 2) }}</strong>
                                </td>
                                <td class="text-center">
                                    <span class="badge badge-secondary">{{ $foc['batches_count'] }}</span>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    @endif

    <!-- Warehouse Inventory -->
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2 text-success">inventory_2</i>
                Warehouse Inventory ({{ $warehouseInventory->count() }} batches)
            </h6>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-sm mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th>Division</th>
                            <th>Batch Number</th>
                            <th class="text-right">Quantity</th>
                            <th class="text-right">Unit Price</th>
                            <th class="text-right">Total Value</th>
                            <th class="text-center">Production Date</th>
                            <th class="text-center">Expiry Date</th>
                            <th class="text-center">Days to Expiry</th>
                            <th class="text-center">Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($warehouseInventory as $inventory)
                            <tr class="{{ $inventory['days_until_expiry'] !== null && $inventory['days_until_expiry'] < 0 ? 'table-danger' : ($inventory['days_until_expiry'] !== null && $inventory['days_until_expiry'] <= 30 ? 'table-warning' : '') }}">
                                <td>
                                    <span class="badge badge-light">{{ $inventory['location'] }}</span>
                                </td>
                                <td>
                                    <code>{{ $inventory['batch_number'] ?: '-' }}</code>
                                </td>
                                <td class="text-right">
                                    <strong>{{ number_format($inventory['quantity_available'], 2) }}</strong> {{ $item->unit_of_measure }}
                                </td>
                                <td class="text-right">
                                    AED {{ number_format($inventory['unit_price'], 2) }}
                                </td>
                                <td class="text-right">
                                    <strong>AED {{ number_format($inventory['total_value'], 2) }}</strong>
                                </td>
                                <td class="text-center">
                                    {{ $inventory['production_date'] ? $inventory['production_date']->format('d M, Y') : '-' }}
                                </td>
                                <td class="text-center">
                                    @if($inventory['expiry_date'])
                                        {{ $inventory['expiry_date']->format('d M, Y') }}
                                    @else
                                        -
                                    @endif
                                </td>
                                <td class="text-center">
                                    @if($inventory['days_until_expiry'] !== null)
                                        @if($inventory['days_until_expiry'] < 0)
                                            <span class="text-danger font-weight-bold">Expired ({{ abs($inventory['days_until_expiry']) }} days ago)</span>
                                        @elseif($inventory['days_until_expiry'] <= 30)
                                            <span class="text-warning font-weight-bold">{{ $inventory['days_until_expiry'] }} days</span>
                                        @else
                                            <span class="text-success">{{ $inventory['days_until_expiry'] }} days</span>
                                        @endif
                                    @else
                                        -
                                    @endif
                                </td>
                                <td class="text-center">
                                    <span class="badge badge-{{
                                        $inventory['status'] === 'in_stock' ? 'success' :
                                        ($inventory['status'] === 'low_stock' ? 'warning' : 'danger')
                                    }}">
                                        {{ ucfirst(str_replace('_', ' ', $inventory['status'])) }}
                                    </span>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="9" class="text-center py-3">
                                    <span class="text-muted">No warehouse inventory found</span>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Detailed Project Inventory -->
    @if($projectInventory->count() > 0)
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2 text-info">assignment</i>
                Detailed Project Allocation ({{ $projectInventory->count() }} allocations)
            </h6>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-sm mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th>Project Name</th>
                            <th class="text-right">Available</th>
                            <th class="text-right">Allocated</th>
                            <th class="text-right">Transferable</th>
                            <th class="text-right">Unit Price</th>
                            <th class="text-right">Total Value</th>
                            <th class="text-center">Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($projectInventory as $inventory)
                            <tr>
                                <td>
                                    <span class="badge badge-primary">{{ $inventory['location'] }}</span>
                                </td>
                                <td class="text-right">
                                    <strong>{{ number_format($inventory['quantity_available'], 2) }}</strong> {{ $item->unit_of_measure }}
                                </td>
                                <td class="text-right">
                                    <span class="text-warning">{{ number_format($inventory['allocated_quantity'], 2) }}</span> {{ $item->unit_of_measure }}
                                </td>
                                <td class="text-right">
                                    <span class="text-success">{{ number_format($inventory['available_for_transfer'], 2) }}</span> {{ $item->unit_of_measure }}
                                </td>
                                <td class="text-right">
                                    AED {{ number_format($inventory['unit_price'], 2) }}
                                </td>
                                <td class="text-right">
                                    <strong>AED {{ number_format($inventory['total_value'], 2) }}</strong>
                                </td>
                                <td class="text-center">
                                    <span class="badge badge-success">{{ ucfirst(str_replace('_', ' ', $inventory['status'])) }}</span>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    @endif

    <!-- Detailed FOC Inventory -->
    @if($focInventory->count() > 0)
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2 text-warning">healing</i>
                Detailed FOC Inventory ({{ $focInventory->count() }} batches)
            </h6>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-sm mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th>Source</th>
                            <th>Condition</th>
                            <th class="text-right">Available</th>
                            <th class="text-right">Reserved</th>
                            <th class="text-right">Net Available</th>
                            <th>Batch</th>
                            <th class="text-center">Production</th>
                            <th class="text-center">Expiry</th>
                            <th class="text-right">Est. Value</th>
                            <th class="text-center">Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($focInventory as $inventory)
                            <tr class="{{ $inventory['days_until_expiry'] !== null && $inventory['days_until_expiry'] < 0 ? 'table-danger' : ($inventory['days_until_expiry'] !== null && $inventory['days_until_expiry'] <= 30 ? 'table-warning' : '') }}">
                                <td>
                                    <span class="badge badge-warning">{{ $inventory['location'] }}</span>
                                    @if($inventory['source_type'])
                                        <br><small class="text-muted">{{ ucfirst($inventory['source_type']) }}</small>
                                    @endif
                                </td>
                                <td>
                                    <span class="badge badge-{{
                                        $inventory['condition'] === 'good' ? 'success' :
                                        ($inventory['condition'] === 'fair' ? 'warning' : 'danger')
                                    }}">{{ ucfirst($inventory['condition']) }}</span>
                                    @if($inventory['damage_severity'])
                                        <br><small class="text-muted">{{ $inventory['damage_severity'] }} damage</small>
                                    @endif
                                </td>
                                <td class="text-right">
                                    <strong>{{ number_format($inventory['quantity_available'], 2) }}</strong> {{ $item->unit_of_measure }}
                                </td>
                                <td class="text-right">
                                    <span class="text-info">{{ number_format($inventory['quantity_reserved'], 2) }}</span> {{ $item->unit_of_measure }}
                                </td>
                                <td class="text-right">
                                    <span class="text-success">{{ number_format($inventory['net_available'], 2) }}</span> {{ $item->unit_of_measure }}
                                </td>
                                <td>
                                    <code>{{ $inventory['batch_number'] ?: '-' }}</code>
                                </td>
                                <td class="text-center">
                                    {{ $inventory['production_date'] ? $inventory['production_date']->format('d M, Y') : '-' }}
                                </td>
                                <td class="text-center">
                                    @if($inventory['expiry_date'])
                                        {{ $inventory['expiry_date']->format('d M, Y') }}
                                        @if($inventory['days_until_expiry'] !== null)
                                            @if($inventory['days_until_expiry'] < 0)
                                                <br><small class="text-danger">Expired</small>
                                            @elseif($inventory['days_until_expiry'] <= 30)
                                                <br><small class="text-warning">{{ $inventory['days_until_expiry'] }} days</small>
                                            @endif
                                        @endif
                                    @else
                                        -
                                    @endif
                                </td>
                                <td class="text-right">
                                    <span class="text-muted">AED {{ number_format($inventory['estimated_value'], 2) }}</span>
                                    @if($inventory['recoverable_value'] > 0)
                                        <br><small class="text-success">Rec: AED {{ number_format($inventory['recoverable_value'], 2) }}</small>
                                    @endif
                                </td>
                                <td class="text-center">
                                    <span class="badge badge-success">{{ ucfirst($inventory['status']) }}</span>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    @endif

    <!-- Price Analysis Summary -->
    <div class="row">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="material-icons mr-2">analytics</i>
                        Price Analysis
                    </h6>
                </div>
                <div class="card-body">
                    @if($pricingHistory->count() > 0)
                        <div class="list-group list-group-flush">
                            <div class="list-group-item d-flex justify-content-between px-0">
                                <span><strong>Lowest Purchase Price:</strong></span>
                                <span class="text-success font-weight-bold">AED {{ number_format($pricingHistory->min('unit_price'), 2) }}</span>
                            </div>
                            <div class="list-group-item d-flex justify-content-between px-0">
                                <span><strong>Highest Purchase Price:</strong></span>
                                <span class="text-danger font-weight-bold">AED {{ number_format($pricingHistory->max('unit_price'), 2) }}</span>
                            </div>
                            <div class="list-group-item d-flex justify-content-between px-0">
                                <span><strong>Average Purchase Price:</strong></span>
                                <span class="text-primary font-weight-bold">AED {{ number_format($pricingHistory->avg('unit_price'), 2) }}</span>
                            </div>
                            <div class="list-group-item d-flex justify-content-between px-0">
                                <span><strong>Current Weighted Average:</strong></span>
                                <span class="text-info font-weight-bold">
                                    AED {{ $totalQuantity > 0 ? number_format($totalValue / $totalQuantity, 2) : '0.00' }}
                                </span>
                            </div>
                            <div class="list-group-item d-flex justify-content-between px-0">
                                <span><strong>Price Variance:</strong></span>
                                <span class="text-warning font-weight-bold">
                                    AED {{ number_format($pricingHistory->max('unit_price') - $pricingHistory->min('unit_price'), 2) }}
                                </span>
                            </div>
                        </div>
                    @else
                        <div class="text-center text-muted">
                            <p>No pricing data available</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="material-icons mr-2">donut_large</i>
                        Material Distribution
                    </h6>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        <!-- Warehouse Distribution -->
                        @if($warehouseInventory->count() > 0)
                            <div class="list-group-item px-0">
                                <div class="font-weight-bold text-success mb-2">
                                    <i class="material-icons" style="font-size: 16px;">store</i>
                                    Warehouse Inventory
                                </div>
                                @foreach($warehouseInventory->groupBy('location') as $location => $items)
                                    <div class="d-flex justify-content-between align-items-center ml-3 mb-1">
                                        <div>
                                            <div class="font-weight-medium">{{ $location }}</div>
                                            <small class="text-muted">{{ $items->count() }} batches</small>
                                        </div>
                                        <div class="text-right">
                                            <div class="font-weight-bold">{{ number_format($items->sum('quantity_available'), 2) }} {{ $item->unit_of_measure }}</div>
                                            <small class="text-muted">AED {{ number_format($items->sum('total_value'), 2) }}</small>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif

                        <!-- Project Distribution -->
                        @if($projectSummary->count() > 0)
                            <div class="list-group-item px-0">
                                <div class="font-weight-bold text-primary mb-2">
                                    <i class="material-icons" style="font-size: 16px;">business</i>
                                    Project Allocations
                                </div>
                                @foreach($projectSummary as $project)
                                    <div class="d-flex justify-content-between align-items-center ml-3 mb-1">
                                        <div>
                                            <div class="font-weight-medium">{{ $project['project_name'] }}</div>
                                            <small class="text-muted">{{ $project['batches_count'] }} allocations</small>
                                        </div>
                                        <div class="text-right">
                                            <div class="font-weight-bold">{{ number_format($project['total_quantity'], 2) }} {{ $item->unit_of_measure }}</div>
                                            <small class="text-muted">AED {{ number_format($project['total_value'], 2) }}</small>
                                            <br><small class="text-success">{{ number_format($project['available_for_transfer'], 2) }} transferable</small>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif

                        <!-- FOC Distribution -->
                        @if($focSummary->count() > 0)
                            <div class="list-group-item px-0">
                                <div class="font-weight-bold text-warning mb-2">
                                    <i class="material-icons" style="font-size: 16px;">volunteer_activism</i>
                                    FOC Materials
                                </div>
                                @foreach($focSummary as $foc)
                                    <div class="d-flex justify-content-between align-items-center ml-3 mb-1">
                                        <div>
                                            <div class="font-weight-medium">{{ $foc['project_name'] }}</div>
                                            <small class="text-muted">{{ $foc['batches_count'] }} batches</small>
                                        </div>
                                        <div class="text-right">
                                            <div class="font-weight-bold">{{ number_format($foc['total_quantity'], 2) }} {{ $item->unit_of_measure }}</div>
                                            <small class="text-success">AED {{ number_format($foc['recoverable_value'], 2) }} recoverable</small>
                                            <br><small class="text-success">{{ number_format($foc['net_available'], 2) }} available</small>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif

                        @if($warehouseInventory->count() == 0 && $projectSummary->count() == 0 && $focSummary->count() == 0)
                            <div class="text-center text-muted py-3">
                                <p>No material distribution data available</p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('styles')
    <style>
        .table-borderless td {
            border: none;
            padding: 0.25rem 0.5rem;
        }

        .badge-outline-primary {
            color: #007bff;
            border: 1px solid #007bff;
            background-color: transparent;
        }

        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            font-size: 12px;
        }

        .table td {
            font-size: 13px;
            vertical-align: middle;
        }

        .list-group-item {
            border-left: none;
            border-right: none;
        }

        code {
            font-size: 12px;
            color: #6c757d;
            background-color: #f8f9fa;
            padding: 2px 6px;
            border-radius: 3px;
        }

        .table-danger {
            background-color: rgba(220, 53, 69, 0.1);
        }

        .table-warning {
            background-color: rgba(255, 193, 7, 0.1);
        }
    </style>
@endpush

@push('scripts')
    <script>
        function printMaterialDetails() {
            window.print();
        }
    </script>
@endpush