@extends('layouts.admin-simple')

@section('title', 'Low Stock Report')

@section('breadcrumb')
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.reports.index') }}">Reports</a></li>
    <li class="breadcrumb-item active">Low Stock Report</li>
@endsection

@section('page-title')
    <div class="page-title-left">
        <h3 class="mb-1">Low Stock Report</h3>
        <p class="text-muted mb-0" style="font-size: 13px;">Items that are running low on inventory</p>
    </div>
@endsection

@section('content')
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="material-icons align-middle mr-2">warning</i>
                Low Stock Items
            </h5>
        </div>
        <div class="card-body">
            <p class="text-muted">This report shows items that are running low on inventory and need to be reordered.</p>

            <div class="alert alert-info">
                <i class="material-icons align-middle mr-2">info</i>
                This feature is under development. The low stock threshold and item data will be configured soon.
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
// Future implementation for low stock report functionality
</script>
@endpush