@extends('layouts.admin-simple')

@section('title', 'Outgoing Transactions')

@section('content')
<div class="container-fluid px-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-2 text-gray-800">
                        <i class="material-icons align-middle mr-2">exit_to_app</i>
                        Outgoing Transactions
                    </h1>
                    <p class="text-muted mb-0">Material dispatch and inventory management system</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <x-warehouse.stats-card
                title="Total Transactions"
                :value="$transactions->total()"
                icon="receipt_long"
                color="primary"
                subtitle="All outgoing transactions"
                url="{{ route('warehouse.outgoing.index') }}"
            />
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <x-warehouse.stats-card
                title="Pending Approval"
                :value="$transactions->where('status', 'pending')->count()"
                icon="pending_actions"
                color="warning"
                subtitle="Awaiting manager approval"
                url="{{ route('warehouse.outgoing.index', ['status' => 'pending']) }}"
            />
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <x-warehouse.stats-card
                title="Approved"
                :value="$transactions->where('status', 'approved')->count()"
                icon="check_circle"
                color="success"
                subtitle="Ready for dispatch"
                url="{{ route('warehouse.outgoing.index', ['status' => 'approved']) }}"
            />
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <x-warehouse.stats-card
                title="Completed"
                :value="$transactions->where('status', 'completed')->count()"
                icon="local_shipping"
                color="info"
                subtitle="Materials dispatched"
                url="{{ route('warehouse.outgoing.index', ['status' => 'completed']) }}"
            />
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="material-icons align-middle mr-1">filter_list</i>
                Filters
            </h6>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('warehouse.outgoing.index') }}">
                <div class="row">
                    <div class="col-lg-2 col-md-4 mb-2">
                        <div style="font-size: 12px; margin-bottom: 8px;">
                            <x-warehouse.select2-dropdown
                                name="status"
                                id="status"
                                label="Status"
                                placeholder="All Status"
                                :options="[
                                    ['value' => '', 'text' => 'All Status'],
                                    ['value' => 'pending', 'text' => 'Pending'],
                                    ['value' => 'approved', 'text' => 'Approved'],
                                    ['value' => 'completed', 'text' => 'Completed']
                                ]"
                                :selected="request('status')"
                                class="form-control-sm"
                                allowClear="true"
                            />
                        </div>
                    </div>
                    <div class="col-lg-2 col-md-4 mb-2">
                        <div style="font-size: 12px; margin-bottom: 8px;">
                            @php
                                $outgoingProjectOptions = [['value' => '', 'text' => 'All Projects']];
                                foreach($projects as $project) {
                                    $outgoingProjectOptions[] = [
                                        'value' => $project->id,
                                        'text' => $project->project_name
                                    ];
                                }
                            @endphp
                            <x-warehouse.select2-dropdown
                                name="project_id"
                                id="project_id"
                                label="Project"
                                placeholder="All Projects"
                                :options="$outgoingProjectOptions"
                                :selected="request('project_id')"
                                class="form-control-sm"
                                allowClear="true"
                            />
                        </div>
                    </div>
                    <div class="col-lg-2 col-md-4 mb-2">
                        <div style="font-size: 12px; margin-bottom: 8px;">
                            @php
                                $outgoingDivisionOptions = [['value' => '', 'text' => 'All Divisions']];
                                foreach($divisions as $division) {
                                    $outgoingDivisionOptions[] = [
                                        'value' => $division->id,
                                        'text' => $division->division_name
                                    ];
                                }
                            @endphp
                            <x-warehouse.select2-dropdown
                                name="division_id"
                                id="division_id"
                                label="Division"
                                placeholder="All Divisions"
                                :options="$outgoingDivisionOptions"
                                :selected="request('division_id')"
                                class="form-control-sm"
                                allowClear="true"
                            />
                        </div>
                    </div>
                    <div class="col-lg-2 col-md-4 mb-2">
                        <label for="date_from" class="form-label small">Date From</label>
                        <input type="date" name="date_from" id="date_from" class="form-control form-control-sm"
                               value="{{ request('date_from') }}">
                    </div>
                    <div class="col-lg-2 col-md-4 mb-2">
                        <label for="date_to" class="form-label small">Date To</label>
                        <input type="date" name="date_to" id="date_to" class="form-control form-control-sm"
                               value="{{ request('date_to') }}">
                    </div>
                    <div class="col-lg-2 col-md-4 mb-2 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary btn-sm mr-2">
                            <i class="material-icons" style="font-size: 16px;">search</i>
                            Filter
                        </button>
                        <a href="{{ route('warehouse.outgoing.index') }}" class="btn btn-secondary btn-sm">
                            <i class="material-icons" style="font-size: 16px;">clear</i>
                            Clear
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Quick Access Card -->
    <div class="card">
        <div class="card-header">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="material-icons align-middle mr-1">info</i>
                Material Request Management
            </h6>
        </div>
        <div class="card-body text-center py-5">
            <i class="material-icons text-primary mb-3" style="font-size: 64px;">assignment</i>
            <h5 class="text-dark">Material Requests Dashboard</h5>
            <p class="text-muted mb-4">All material requests are now managed through the Material Issued section for better workflow and approval management.</p>

            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <a href="{{ route('warehouse.outgoing.create') }}" class="btn btn-primary btn-block">
                                <i class="material-icons mr-1">add</i>
                                Create New Material Request
                            </a>
                        </div>
                        <div class="col-md-6 mb-3">
                            <a href="{{ route('warehouse.inventory.material-requests') }}" class="btn btn-success btn-block">
                                <i class="material-icons mr-1">list</i>
                                View All Material Requests
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="mt-4 pt-4 border-top">
                <small class="text-muted">
                    <i class="material-icons" style="font-size: 16px;">info</i>
                    Material requests created here will automatically appear in the Material Issued section for approval and dispatch.
                </small>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
/* Adjust Select2 dropdown widths for better proportions */
.select2-container {
    width: 100% !important;
}

/* Make dropdowns auto-width based on content */
.select2-dropdown {
    min-width: 200px;
    max-width: 400px;
    width: auto !important;
}

/* Ensure the selection box doesn't get too wide */
.select2-container .select2-selection--single {
    min-width: 200px;
    max-width: 100%;
}

/* Allow dropdown to expand based on content */
.select2-container--open .select2-dropdown--below {
    width: auto !important;
    min-width: 200px;
}
</style>
@endpush

@push('scripts')
<script>
    // Auto-submit form when filter values change
    document.addEventListener('DOMContentLoaded', function() {
        const filterInputs = document.querySelectorAll('#status, #project_id, #division_id');
        filterInputs.forEach(input => {
            input.addEventListener('change', function() {
                this.form.submit();
            });
        });
    });
</script>
@endpush