@extends('layouts.admin-simple')

@section('title', $item->item_description)

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('warehouse.items.index') }}">Items</a></li>
    <li class="breadcrumb-item active">{{ $item->item_code }}</li>
@endsection

@section('page-title')
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">{{ $item->item_description }}</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Item Code: {{ $item->item_code }}</p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <a href="{{ route('warehouse.items.index') }}" class="btn btn-sm btn-outline-secondary">
                <i class="material-icons mr-1" style="font-size: 16px;">arrow_back</i>
                Back to List
            </a>
        </div>
    </div>
@endsection

@section('content')
    <!-- Item Information -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Item Information</h6>
        </div>

        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <h6 class="text-primary font-weight-bold mb-3">Basic Information</h6>
                    <dl class="row">
                        <dt class="col-sm-4 text-muted">Item Code</dt>
                        <dd class="col-sm-8">{{ $item->item_code }}</dd>

                        <dt class="col-sm-4 text-muted">Item Description</dt>
                        <dd class="col-sm-8">{{ $item->item_description }}</dd>

                        <dt class="col-sm-4 text-muted">Category</dt>
                        <dd class="col-sm-8">
                            @if($item->category)
                                <a href="{{ route('warehouse.item-categories.show', $item->category->id) }}">
                                    {{ $item->category->category_name }}
                                </a>
                            @else
                                <span class="text-muted">No category assigned</span>
                            @endif
                        </dd>

                        <dt class="col-sm-4 text-muted">Unit of Measure</dt>
                        <dd class="col-sm-8">{{ $item->unit ? $item->unit->display_name : $item->unit_of_measure }}</dd>

                        <dt class="col-sm-4 text-muted">Status</dt>
                        <dd class="col-sm-8">
                            @if($item->status === 'active')
                                <span class="badge badge-success">Active</span>
                            @elseif($item->status === 'inactive')
                                <span class="badge badge-secondary">Inactive</span>
                            @else
                                <span class="badge badge-warning">{{ ucfirst($item->status) }}</span>
                            @endif
                        </dd>

                        <dt class="col-sm-4 text-muted">Created Date</dt>
                        <dd class="col-sm-8">{{ $item->created_at->format('M d, Y H:i') }}</dd>

                        <dt class="col-sm-4 text-muted">Last Updated</dt>
                        <dd class="col-sm-8">{{ $item->updated_at->format('M d, Y H:i') }}</dd>
                    </dl>
                </div>

                <div class="col-md-6">
                    <h6 class="text-primary font-weight-bold mb-3">Stock Information</h6>
                    <dl class="row">
                        <dt class="col-sm-4 text-muted">Min Stock Level</dt>
                        <dd class="col-sm-8">{{ $item->min_stock_level ?: 'Not set' }}</dd>

                        <dt class="col-sm-4 text-muted">Max Stock Level</dt>
                        <dd class="col-sm-8">{{ $item->max_stock_level ?: 'Not set' }}</dd>

                        <dt class="col-sm-4 text-muted">Reorder Point</dt>
                        <dd class="col-sm-8">{{ $item->reorder_point ?: 'Not set' }}</dd>

                        <dt class="col-sm-4 text-muted">Current Stock</dt>
                        <dd class="col-sm-8">
                            @php
                                $totalStock = $item->inventories->sum('quantity_available');
                            @endphp
                            <span class="badge badge-info">{{ $totalStock }} {{ $item->unit ? $item->unit->unit_symbol : $item->unit_of_measure }}</span>
                        </dd>

                        <dt class="col-sm-4 text-muted">Stock Locations</dt>
                        <dd class="col-sm-8">
                            <span class="badge badge-primary">{{ $item->inventories->count() }} location(s)</span>
                        </dd>
                    </dl>

                    @if($item->notes)
                        <h6 class="text-primary font-weight-bold mb-3 mt-4">Notes</h6>
                        <p class="text-muted">{{ $item->notes }}</p>
                    @endif
                </div>
            </div>
        </div>
    </div>

    @if($item->stockMovements->count() > 0)
    <!-- Recent Stock Movements -->
    <div class="card shadow">
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-primary">Recent Stock Movements</h6>
            <small class="text-muted">Last 10 movements</small>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Type</th>
                            <th>Quantity</th>
                            <th>Reference</th>
                            <th>Notes</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($item->stockMovements->take(10) as $movement)
                        <tr>
                            <td>{{ $movement->created_at->format('M d, Y H:i') }}</td>
                            <td>
                                @if($movement->movement_type === 'in')
                                    <span class="badge badge-success">Stock In</span>
                                @else
                                    <span class="badge badge-danger">Stock Out</span>
                                @endif
                            </td>
                            <td>
                                @if($movement->movement_type === 'in')
                                    <span class="text-success">+{{ $movement->quantity }}</span>
                                @else
                                    <span class="text-danger">-{{ $movement->quantity }}</span>
                                @endif
                                {{ $item->unit ? $item->unit->unit_symbol : $item->unit_of_measure }}
                            </td>
                            <td>{{ $movement->reference_number ?? 'N/A' }}</td>
                            <td>{{ $movement->notes ?? 'No notes' }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    @endif
@endsection