@extends('layouts.admin-simple')

@section('title', 'Edit Item Type')
@section('page-title', 'Edit Item Type')
@section('page-subtitle', 'Update item type information')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('warehouse.item-types.index') }}">Item Types</a></li>
    <li class="breadcrumb-item active">Edit</li>
@endsection

@section('content')
<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex justify-content-between align-items-center">
        <h6 class="m-0 font-weight-bold text-primary">Edit Item Type Information</h6>
        <span class="text-muted">ID: {{ $itemType->id }}</span>
    </div>

    <div class="card-body">
        <form action="{{ route('warehouse.item-types.update', $itemType->id) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="type_name" class="form-label">Type Name <span class="text-danger">*</span></label>
                        <input type="text" name="type_name" id="type_name"
                               class="form-control @error('type_name') is-invalid @enderror"
                               value="{{ old('type_name', $itemType->type_name) }}" required>
                        @error('type_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="type_code" class="form-label">Type Code</label>
                        <input type="text" name="type_code" id="type_code"
                               class="form-control @error('type_code') is-invalid @enderror"
                               value="{{ old('type_code', $itemType->type_code) }}">
                        @error('type_code')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                        <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                            <option value="active" {{ old('status', $itemType->status) == 'active' ? 'selected' : '' }}>Active</option>
                            <option value="inactive" {{ old('status', $itemType->status) == 'inactive' ? 'selected' : '' }}>Inactive</option>
                        </select>
                        @error('status')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label for="description" class="form-label">Description</label>
                        <textarea name="description" id="description" rows="3"
                                  class="form-control @error('description') is-invalid @enderror"
                                  placeholder="Optional description for this item type">{{ old('description', $itemType->description) }}</textarea>
                        @error('description')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="d-flex justify-content-between mt-4 pt-3 border-top">
                <a href="{{ route('warehouse.item-types.index') }}" class="btn btn-secondary">
                    <i class="material-icons mr-1" style="font-size: 16px;">cancel</i>
                    Cancel
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="material-icons mr-1" style="font-size: 16px;">save</i>
                    Update Item Type
                </button>
            </div>
        </form>
    </div>
</div>
@endsection