@extends('layouts.admin-simple')

@section('title', 'Material Request Details')

@section('content')
<div class="container-fluid px-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-2 text-gray-800">
                        <i class="material-icons align-middle mr-2">assignment</i>
                        Material Request Details
                    </h1>
                    <p class="text-muted mb-0">Request #{{ $materialRequest['request_number'] }}</p>
                </div>
                <div>
                    <a href="{{ route('warehouse.inventory.material-requests') }}" class="btn btn-secondary">
                        <i class="material-icons mr-1">arrow_back</i>
                        Back to List
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Status Alert -->
    @if($materialRequest['status'] === 'pending')
        <div class="alert alert-warning">
            <i class="material-icons align-middle mr-2">pending</i>
            <strong>Pending Approval:</strong> This material request is waiting for manager approval and dispatch.
        </div>
    @elseif($materialRequest['status'] === 'successful')
        <div class="alert alert-success">
            <i class="material-icons align-middle mr-2">check_circle</i>
            <strong>Successful:</strong> Materials have been approved and dispatched successfully. Inventory has been updated.
        </div>
    @elseif($materialRequest['status'] === 'canceled')
        <div class="alert alert-danger">
            <i class="material-icons align-middle mr-2">cancel</i>
            <strong>Canceled:</strong> This material request has been canceled and no materials were dispatched.
        </div>
    @endif

    <div class="row">
        <!-- Request Details -->
        <div class="col-lg-8">
            <!-- Request Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="material-icons align-middle mr-1">info</i>
                        Request Information
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Request Number:</strong><br>{{ $materialRequest['request_number'] }}</p>
                            @if($materialRequest['material_request_number'])
                                <p><strong>Material Request Number:</strong><br>{{ $materialRequest['material_request_number'] }}</p>
                            @endif
                            <p><strong>Request Date:</strong><br>{{ $materialRequest['request_date'] }}</p>
                            <p><strong>Status:</strong><br>
                                @switch($materialRequest['status'])
                                    @case('pending')
                                        <span class="badge badge-warning">
                                            <i class="material-icons" style="font-size: 12px;">pending</i>
                                            Pending Approval
                                        </span>
                                        @break
                                    @case('successful')
                                        <span class="badge badge-success">
                                            <i class="material-icons" style="font-size: 12px;">check_circle</i>
                                            Successful
                                        </span>
                                        @break
                                    @case('canceled')
                                        <span class="badge badge-danger">
                                            <i class="material-icons" style="font-size: 12px;">cancel</i>
                                            Canceled
                                        </span>
                                        @break
                                @endswitch
                            </p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Requested By:</strong><br>{{ $materialRequest['requested_by'] }}</p>
                            <p><strong>Project:</strong><br>{{ $materialRequest['project'] }}</p>
                            @if($materialRequest['notes'])
                                <p><strong>Notes:</strong><br>{{ $materialRequest['notes'] }}</p>
                            @endif
                            @if($materialRequest['request_file'])
                                <p><strong>Attached File:</strong><br>
                                    <a href="{{ asset($materialRequest['request_file']) }}"
                                       target="_blank"
                                       class="btn btn-sm btn-outline-success">
                                        <i class="material-icons mr-1" style="font-size: 16px;">attachment</i>
                                        View Uploaded File
                                    </a>
                                </p>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Items -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="material-icons align-middle mr-1">shopping_cart</i>
                        Requested Items ({{ count($materialRequest['items']) }})
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th>Item Code</th>
                                    <th>Description</th>
                                    <th>Unit</th>
                                    <th>Qty Requested</th>
                                    <th>Qty Released</th>
                                    <th>Balance</th>
                                    <th>Available Stock</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($materialRequest['items'] as $item)
                                    <tr>
                                        <td>
                                            <strong class="text-primary">{{ $item['item_code'] }}</strong>
                                        </td>
                                        <td>{{ $item['description'] }}</td>
                                        <td class="text-center">
                                            <span class="badge badge-secondary">{{ $item['unit'] }}</span>
                                        </td>
                                        <td class="text-right">{{ number_format($item['quantity_requested'], 2) }}</td>
                                        <td class="text-right">
                                            @if($item['quantity_released'] > 0)
                                                <span class="text-success">{{ number_format($item['quantity_released'], 2) }}</span>
                                            @else
                                                <span class="text-muted">{{ number_format($item['quantity_released'], 2) }}</span>
                                            @endif
                                        </td>
                                        <td class="text-right">
                                            @if($item['quantity_remaining'] > 0)
                                                <span class="text-warning">{{ number_format($item['quantity_remaining'], 2) }}</span>
                                            @else
                                                <span class="text-success">0.00</span>
                                            @endif
                                        </td>
                                        <td class="text-right">
                                            <span class="text-{{ $item['quantity_available'] >= $item['quantity_requested'] ? 'success' : 'danger' }}">
                                                {{ number_format($item['quantity_available'], 2) }}
                                            </span>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center text-muted py-4">
                                            <i class="material-icons mb-2" style="font-size: 48px; opacity: 0.3;">shopping_cart</i>
                                            <div>No items found in this request</div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Material Issue Files -->
            @if($materialRequest['material_issue_files']->count() > 0)
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="material-icons align-middle mr-1">attachment</i>
                        Material Issue Supporting Documents
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        @if($materialRequest['material_issue_files']->has('inventory'))
                            <div class="col-md-4 mb-3">
                                <h6 class="text-success">
                                    <i class="material-icons align-middle mr-1">inventory</i>
                                    Inventory Dispatch
                                </h6>
                                @foreach($materialRequest['material_issue_files']['inventory'] as $file)
                                    <div class="mb-2">
                                        <a href="{{ asset($file->file_path) }}"
                                           target="_blank"
                                           class="btn btn-sm btn-outline-success">
                                            <i class="material-icons mr-1" style="font-size: 16px;">description</i>
                                            {{ $file->original_filename }}
                                        </a>
                                        <br><small class="text-muted">Uploaded by {{ $file->uploader->name ?? 'N/A' }}</small>
                                    </div>
                                @endforeach
                            </div>
                        @endif

                        @if($materialRequest['material_issue_files']->has('delivery'))
                            <div class="col-md-4 mb-3">
                                <h6 class="text-info">
                                    <i class="material-icons align-middle mr-1">local_shipping</i>
                                    Direct Delivery
                                </h6>
                                @foreach($materialRequest['material_issue_files']['delivery'] as $file)
                                    <div class="mb-2">
                                        <a href="{{ asset($file->file_path) }}"
                                           target="_blank"
                                           class="btn btn-sm btn-outline-info">
                                            <i class="material-icons mr-1" style="font-size: 16px;">description</i>
                                            {{ $file->original_filename }}
                                        </a>
                                        <br><small class="text-muted">Uploaded by {{ $file->uploader->name ?? 'N/A' }}</small>
                                    </div>
                                @endforeach
                            </div>
                        @endif

                        @if($materialRequest['material_issue_files']->has('transfer'))
                            <div class="col-md-4 mb-3">
                                <h6 class="text-primary">
                                    <i class="material-icons align-middle mr-1">swap_horiz</i>
                                    Project Transfer
                                </h6>
                                @foreach($materialRequest['material_issue_files']['transfer'] as $file)
                                    <div class="mb-2">
                                        <a href="{{ asset($file->file_path) }}"
                                           target="_blank"
                                           class="btn btn-sm btn-outline-primary">
                                            <i class="material-icons mr-1" style="font-size: 16px;">description</i>
                                            {{ $file->original_filename }}
                                        </a>
                                        <br><small class="text-muted">Uploaded by {{ $file->uploader->name ?? 'N/A' }}</small>
                                    </div>
                                @endforeach
                            </div>
                        @endif
                    </div>
                </div>
            </div>
            @endif

            <!-- Fulfillment History -->
            @php
                $hasAnyFulfillments = collect($materialRequest['items'])->some(function($item) {
                    return isset($item['release_details']) && $item['release_details']->count() > 0;
                });
            @endphp

            @if($hasAnyFulfillments)
            <div class="card">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="material-icons align-middle mr-1">history</i>
                        Fulfillment History
                    </h6>
                </div>
                <div class="card-body">
                    @foreach($materialRequest['items'] as $item)
                        @if(isset($item['release_details']) && $item['release_details']->count() > 0)
                            <div class="mb-4">
                                <h6 class="text-primary mb-3">
                                    <i class="material-icons align-middle mr-1" style="font-size: 18px;">inventory</i>
                                    {{ $item['item_code'] }} - {{ $item['description'] }}
                                </h6>
                                
                                <div class="row">
                                    @foreach($item['release_details'] as $fulfillment)
                                        <div class="col-md-6 mb-3">
                                            <div class="card border-left-{{ $fulfillment->fulfillment_type === 'inventory' ? 'success' : ($fulfillment->fulfillment_type === 'direct_delivery' ? 'info' : 'primary') }}">
                                                <div class="card-body py-2">
                                                    <div class="d-flex align-items-center">
                                                        <div class="mr-3">
                                                            @if($fulfillment->fulfillment_type === 'inventory')
                                                                <i class="material-icons text-success">inventory</i>
                                                            @elseif($fulfillment->fulfillment_type === 'direct_delivery')
                                                                <i class="material-icons text-info">local_shipping</i>
                                                            @else
                                                                <i class="material-icons text-primary">swap_horiz</i>
                                                            @endif
                                                        </div>
                                                        <div class="flex-grow-1">
                                                            <div class="small font-weight-bold text-uppercase">
                                                                @if($fulfillment->fulfillment_type === 'inventory')
                                                                    Inventory Dispatch
                                                                @elseif($fulfillment->fulfillment_type === 'direct_delivery')
                                                                    Direct Delivery
                                                                @else
                                                                    Project Transfer
                                                                @endif
                                                            </div>
                                                            <div class="h6 mb-1">{{ number_format($fulfillment->quantity_fulfilled, 2) }} {{ $item['unit'] }}</div>
                                                            <div class="small text-muted">{{ $fulfillment->created_at->format('M d, Y H:i') }}</div>
                                                            @if($fulfillment->notes)
                                                                <div class="small text-muted">{{ $fulfillment->notes }}</div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>

                                <!-- Item summary -->
                                <div class="row mt-2">
                                    <div class="col-12">
                                        <div class="bg-light p-2 rounded">
                                            <small class="text-muted">
                                                <strong>Summary:</strong> 
                                                Requested: {{ number_format($item['quantity_requested'], 2) }} {{ $item['unit'] }} | 
                                                Fulfilled: {{ number_format($item['quantity_released'], 2) }} {{ $item['unit'] }} | 
                                                Remaining: {{ number_format($item['quantity_remaining'], 2) }} {{ $item['unit'] }}
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                        @endif
                    @endforeach
                </div>
            </div>
            @endif
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Quick Actions -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="material-icons align-middle mr-1">settings</i>
                        Quick Actions
                    </h6>
                </div>
                <div class="card-body">
                    <a href="{{ route('warehouse.inventory.material-requests') }}" class="btn btn-outline-primary btn-block">
                        <i class="material-icons mr-1">list</i>
                        All Requests
                    </a>
                </div>
            </div>

            <!-- Request Summary -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="material-icons align-middle mr-1">assessment</i>
                        Summary
                    </h6>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-2">
                        <span>Total Items:</span>
                        <strong>{{ count($materialRequest['items']) }}</strong>
                    </div>
                    @php
                        $canFulfill = collect($materialRequest['items'])->every(function($item) {
                            return $item['quantity_available'] >= $item['quantity_remaining'];
                        });
                    @endphp
                    <div class="d-flex justify-content-between mb-2">
                        <span>Total Qty Requested:</span>
                        <strong>{{ number_format($materialRequest['total_requested'], 2) }}</strong>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Total Qty Released:</span>
                        <strong>{{ number_format($materialRequest['total_released'], 2) }}</strong>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Total Qty Remaining:</span>
                        <strong class="text-warning">{{ number_format($materialRequest['total_remaining'], 2) }}</strong>
                    </div>
                    <hr>
                    <div class="d-flex justify-content-between">
                        <span>Can Fulfill:</span>
                        <span class="badge badge-{{ $canFulfill ? 'success' : 'danger' }}">
                            {{ $canFulfill ? 'Yes' : 'No' }}
                        </span>
                    </div>
                </div>
            </div>

            <!-- Activity Timeline -->
            <div class="card">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="material-icons align-middle mr-1">timeline</i>
                        Request Timeline
                    </h6>
                </div>
                <div class="card-body">
                    <div class="timeline">
                        <!-- Created -->
                        <div class="timeline-item">
                            <div class="timeline-marker bg-primary"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Request Created</h6>
                                <p class="timeline-text">
                                    {{ $materialRequest['request_date'] }}
                                    <br><small class="text-muted">by {{ $materialRequest['requested_by'] }}</small>
                                </p>
                            </div>
                        </div>

                        @if($materialRequest['status'] === 'successful')
                        <!-- Successful -->
                        <div class="timeline-item">
                            <div class="timeline-marker bg-success"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Approved & Dispatched</h6>
                                <p class="timeline-text">
                                    Materials dispatched and inventory updated
                                </p>
                            </div>
                        </div>
                        @endif

                        @if($materialRequest['status'] === 'canceled')
                        <!-- Canceled -->
                        <div class="timeline-item">
                            <div class="timeline-marker bg-danger"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Request Canceled</h6>
                                <p class="timeline-text">
                                    Request was canceled before dispatch
                                </p>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .timeline {
        position: relative;
        padding-left: 30px;
    }
    .timeline:before {
        content: '';
        position: absolute;
        left: 8px;
        top: 0;
        bottom: 0;
        width: 2px;
        background: #e3e6f0;
    }
    .timeline-item {
        position: relative;
        margin-bottom: 20px;
    }
    .timeline-marker {
        position: absolute;
        left: -22px;
        top: 5px;
        width: 16px;
        height: 16px;
        border-radius: 50%;
        border: 2px solid #fff;
    }
    .timeline-title {
        font-size: 14px;
        font-weight: 600;
        color: #5a5c69;
        margin-bottom: 5px;
    }
    .timeline-text {
        font-size: 13px;
        color: #858796;
        margin-bottom: 0;
    }
</style>
@endpush