@extends('layouts.admin-simple')

@section('title', 'Material Issued Details')

@section('content')
<div class="container-fluid px-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-2 text-gray-800">
                        <i class="material-icons align-middle mr-2">assignment_turned_in</i>
                        Material Issued Details
                    </h1>
                    <p class="text-muted mb-0">Issue #{{ $materialIssued['issue_number'] }}</p>
                </div>
                <div>
                    <button onclick="printIssueNote({{ $materialIssued['id'] }})" class="btn btn-info">
                        <i class="material-icons mr-1">print</i>
                        Print Issue Note
                    </button>
                    <a href="{{ route('warehouse.inventory.material-issued') }}" class="btn btn-secondary">
                        <i class="material-icons mr-1">arrow_back</i>
                        Back to List
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Status Alert -->
    <div class="alert alert-success">
        <i class="material-icons align-middle mr-2">check_circle</i>
        <strong>Material Issued:</strong> Materials have been successfully dispatched and inventory has been updated.
    </div>

    <div class="row">
        <!-- Issue Details -->
        <div class="col-lg-8">
            <!-- Issue Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="material-icons align-middle mr-1">info</i>
                        Issue Information
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Issue Number:</strong><br>{{ $materialIssued['issue_number'] }}</p>
                            @if($materialIssued['material_request_number'])
                                <p><strong>Material Request Number:</strong><br>{{ $materialIssued['material_request_number'] }}</p>
                            @endif
                            <p><strong>Issue Date:</strong><br>{{ $materialIssued['issue_date'] }}</p>
                            <p><strong>Status:</strong><br>
                                <span class="badge badge-success">
                                    <i class="material-icons" style="font-size: 12px;">check_circle</i>
                                    Issued
                                </span>
                            </p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Issued To:</strong><br>{{ $materialIssued['issued_to'] }}</p>
                            <p><strong>Project:</strong><br>{{ $materialIssued['project'] }}</p>
                            @if($materialIssued['approved_by'])
                                <p><strong>Approved By:</strong><br>{{ $materialIssued['approved_by'] }}</p>
                            @endif
                            @if($materialIssued['notes'])
                                <p><strong>Notes:</strong><br>{{ $materialIssued['notes'] }}</p>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Items -->
            <div class="card">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="material-icons align-middle mr-1">shopping_cart</i>
                        Issued Items ({{ count($materialIssued['items']) }})
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th>Item Code</th>
                                    <th>Description</th>
                                    <th>Unit</th>
                                    <th>Qty Requested</th>
                                    <th>Qty Issued</th>
                                    <th>Unit Price</th>
                                    <th>Total Price</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($materialIssued['items'] as $item)
                                    <tr>
                                        <td>
                                            <strong class="text-primary">{{ $item['item_code'] }}</strong>
                                        </td>
                                        <td>{{ $item['description'] }}</td>
                                        <td class="text-center">
                                            <span class="badge badge-secondary">{{ $item['unit'] }}</span>
                                        </td>
                                        <td class="text-right">{{ number_format($item['quantity_requested'], 2) }}</td>
                                        <td class="text-right">
                                            <span class="text-success">{{ number_format($item['quantity_released'], 2) }}</span>
                                        </td>
                                        <td class="text-right">
                                            @if($item['unit_price'])
                                                AED {{ number_format($item['unit_price'], 2) }}
                                            @else
                                                <span class="text-muted">N/A</span>
                                            @endif
                                        </td>
                                        <td class="text-right">
                                            @if($item['total_price'])
                                                <strong>AED {{ number_format($item['total_price'], 2) }}</strong>
                                            @else
                                                <span class="text-muted">N/A</span>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center text-muted py-4">
                                            <i class="material-icons mb-2" style="font-size: 48px; opacity: 0.3;">shopping_cart</i>
                                            <div>No items found in this issue record</div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                            @if(count($materialIssued['items']) > 0)
                                <tfoot class="thead-light">
                                    <tr>
                                        <th colspan="6" class="text-right">Total:</th>
                                        <th class="text-right">
                                            @php
                                                $totalValue = collect($materialIssued['items'])->sum('total_price');
                                            @endphp
                                            <strong>AED {{ number_format($totalValue, 2) }}</strong>
                                        </th>
                                    </tr>
                                </tfoot>
                            @endif
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Quick Actions -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="material-icons align-middle mr-1">settings</i>
                        Quick Actions
                    </h6>
                </div>
                <div class="card-body">
                    <button onclick="printIssueNote({{ $materialIssued['id'] }})" class="btn btn-info btn-block mb-2">
                        <i class="material-icons mr-1">print</i>
                        Print Issue Note
                    </button>

                    <a href="{{ route('warehouse.inventory.material-issued') }}" class="btn btn-outline-primary btn-block">
                        <i class="material-icons mr-1">list</i>
                        All Issued Materials
                    </a>
                </div>
            </div>

            <!-- Issue Summary -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="material-icons align-middle mr-1">assessment</i>
                        Summary
                    </h6>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-2">
                        <span>Total Items:</span>
                        <strong>{{ count($materialIssued['items']) }}</strong>
                    </div>
                    @php
                        $totalRequested = collect($materialIssued['items'])->sum('quantity_requested');
                        $totalIssued = collect($materialIssued['items'])->sum('quantity_released');
                        $totalValue = collect($materialIssued['items'])->sum('total_price');
                    @endphp
                    <div class="d-flex justify-content-between mb-2">
                        <span>Total Qty Requested:</span>
                        <strong>{{ number_format($totalRequested, 2) }}</strong>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Total Qty Issued:</span>
                        <strong class="text-success">{{ number_format($totalIssued, 2) }}</strong>
                    </div>
                    <hr>
                    <div class="d-flex justify-content-between">
                        <span>Total Value:</span>
                        <strong class="text-primary">AED {{ number_format($totalValue, 2) }}</strong>
                    </div>
                </div>
            </div>

            <!-- Issue Timeline -->
            <div class="card">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="material-icons align-middle mr-1">timeline</i>
                        Issue Timeline
                    </h6>
                </div>
                <div class="card-body">
                    <div class="timeline">
                        <!-- Created -->
                        <div class="timeline-item">
                            <div class="timeline-marker bg-primary"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Request Submitted</h6>
                                <p class="timeline-text">
                                    Original material request submitted
                                    <br><small class="text-muted">by {{ $materialIssued['issued_to'] }}</small>
                                </p>
                            </div>
                        </div>

                        <!-- Approved & Issued -->
                        <div class="timeline-item">
                            <div class="timeline-marker bg-success"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Materials Issued</h6>
                                <p class="timeline-text">
                                    {{ $materialIssued['issue_date'] }}
                                    <br><small class="text-muted">
                                        @if($materialIssued['approved_by'])
                                            Approved by {{ $materialIssued['approved_by'] }}
                                        @else
                                            System processed
                                        @endif
                                    </small>
                                </p>
                            </div>
                        </div>

                        <!-- Inventory Updated -->
                        <div class="timeline-item">
                            <div class="timeline-marker bg-info"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Inventory Updated</h6>
                                <p class="timeline-text">
                                    Stock levels automatically adjusted
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .timeline {
        position: relative;
        padding-left: 30px;
    }
    .timeline:before {
        content: '';
        position: absolute;
        left: 8px;
        top: 0;
        bottom: 0;
        width: 2px;
        background: #e3e6f0;
    }
    .timeline-item {
        position: relative;
        margin-bottom: 20px;
    }
    .timeline-marker {
        position: absolute;
        left: -22px;
        top: 5px;
        width: 16px;
        height: 16px;
        border-radius: 50%;
        border: 2px solid #fff;
    }
    .timeline-title {
        font-size: 14px;
        font-weight: 600;
        color: #5a5c69;
        margin-bottom: 5px;
    }
    .timeline-text {
        font-size: 13px;
        color: #858796;
        margin-bottom: 0;
    }
</style>
@endpush

@push('scripts')
<script>
function printIssueNote(id) {
    // Implement print functionality
    window.print();
}
</script>
@endpush