<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="UTF-8">
    <title>@yield('title', 'UFG')</title>
    <meta name='robots' content='max-image-preview:large' />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <!-- SEO Meta Tags -->
    <meta name="description" content="@yield('description', 'Arabian United Float Glass Company (UFG) - Leading manufacturer of high-quality glass products in Saudi Arabia.')">
    <meta name="keywords" content="@yield('keywords', 'UFG, Arabian United Float Glass, glass manufacturer, float glass, mirror glass, Saudi Arabia')">
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="{{ asset($siteSettings['site_favicon'] ?? 'images/favicon.png') }}">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Custom Styles -->
    <link rel='stylesheet' href='{{ asset("css/custom-nav-hover.css") }}' media='all' />
    <link rel='stylesheet' href='{{ asset("css/media-dropdown.css") }}' media='all' />
    <link rel='stylesheet' href='{{ asset("css/aufg-logo-fix.css") }}' media='all' />
    <link rel="stylesheet" href="{{ asset('assets/css/global-footer-styles.css') }}" />
    <link rel='stylesheet' href='{{ asset("css/hero-text-animation.css") }}' media='all' />
    <link rel='stylesheet' href='{{ asset("css/navigation-fix.css") }}' media='all' />
    <link rel='stylesheet' href='{{ asset("css/who-we-are-background.css") }}' media='all' />
    <link rel='stylesheet' href='{{ asset("css/global-poppins-font.css") }}' media='all' />
    <link rel='stylesheet' href='{{ asset("css/global-buttons.css") }}' media='all' />
    <link rel='stylesheet' href='{{ asset("css/global-colors.css") }}' media='all' />
    <link rel='stylesheet' href='{{ asset("css/global-header-styles.css") }}' media='all' />
    
    <!-- Mobile Products Force Override - Load Last for Maximum Specificity -->
    <link rel='stylesheet' href='{{ asset("css/mobile-products-force.css") }}' media='all' />
    
    <!-- Vite Assets -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    
    <!-- Global Font Settings -->
    <style>
        /* Global Font Settings */
        * {
            font-family: 'Poppins', sans-serif !important;
        }
        
        body, html {
            font-family: 'Poppins', sans-serif !important;
            margin: 0;
            padding: 0;
        }
        
        /* Basic content wrapper */
        .main-content {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        
        .page-content {
            flex: 1;
        }
    </style>
    
    @stack('styles')
</head>
<body class="home page">

    <div class="main-content">
        
        <!-- Header -->
        @include('components.header')
        
        <!-- Main Content -->
        <div class="page-content">
            @yield('content')
        </div>
        
        <!-- Footer -->
        @include('components.footer')
        
    </div>
    
    <!-- Global Scripts -->
    <script src="{{ asset('js/site-loader.js') }}"></script>
    <script src="{{ asset('js/language-selector.js') }}"></script>
    <script src="{{ asset('js/sticky-header.js') }}"></script>
    <script src="{{ asset('js/scroll-animations.js') }}"></script>
    <script src="{{ asset('js/global-header.js') }}"></script>
    <script src="{{ asset('js/hero-video-loop.js') }}"></script>
    <script src="{{ asset('js/carousel-fix.js') }}"></script>
    
    @stack('scripts')
</body>
</html>