<!-- Warehouse Stats Card Component -->
@props([
    'title' => '',
    'value' => 0,
    'icon' => 'assessment',
    'color' => 'primary',
    'trend' => null,
    'trendDirection' => 'up',
    'url' => null,
    'subtitle' => null,
    'loading' => false,
    'currency' => false
])

@php
    $colorClasses = [
        'primary' => ['bg' => 'bg-primary', 'text' => 'text-primary', 'border' => 'border-primary'],
        'success' => ['bg' => 'bg-success', 'text' => 'text-success', 'border' => 'border-success'],
        'warning' => ['bg' => 'bg-warning', 'text' => 'text-warning', 'border' => 'border-warning'],
        'danger' => ['bg' => 'bg-danger', 'text' => 'text-danger', 'border' => 'border-danger'],
        'info' => ['bg' => 'bg-info', 'text' => 'text-info', 'border' => 'border-info'],
        'secondary' => ['bg' => 'bg-secondary', 'text' => 'text-secondary', 'border' => 'border-secondary'],
    ];

    $currentColor = $colorClasses[$color] ?? $colorClasses['primary'];
@endphp

<div class="warehouse-stat-card h-100" style="border-left: 4px solid var(--bs-{{ $color }});">
    @if($url)
        <a href="{{ $url }}" class="text-decoration-none">
    @endif

    <div class="warehouse-stat-card-content">
        <!-- First Line: Icon + Value on same line -->
        <div class="d-flex align-items-center mb-2">
            <!-- Icon -->
            <div class="warehouse-stat-icon mr-2">
                <div class="rounded-circle {{ $currentColor['bg'] }} text-white d-flex align-items-center justify-content-center"
                     style="width: 35px; height: 35px;">
                    @if($loading)
                        <div class="spinner-border spinner-border-sm" role="status">
                            <span class="sr-only">Loading...</span>
                        </div>
                    @else
                        <i class="material-icons" style="font-size: 20px;">{{ $icon }}</i>
                    @endif
                </div>
            </div>

            <!-- Value -->
            <div class="warehouse-stat-value flex-fill" style="min-width: 0;">
                @if($loading)
                    <div class="placeholder-glow">
                        <span class="placeholder col-6"></span>
                    </div>
                @else
                    <div class="warehouse-stat-value-container" title="@if($currency){{ is_numeric($value) ? 'AED ' . number_format($value, 2) : $value }}@else{{ is_numeric($value) ? number_format($value) : $value }}@endif">
                        <h3 class="mb-0 font-weight-bold {{ $currentColor['text'] }} warehouse-stat-value-text" style="font-size: 1.4rem; line-height: 1;">
                            @if($currency)
                                <span class="dirham-symbol {{ $currentColor['text'] }}" style="width: 16px; height: 16px; margin-right: 3px; display: inline-flex; align-items: center; flex-shrink: 0;">
                                    <svg viewBox="0 0 1000 870" width="16" height="16" style="fill: currentColor;">
                                        <path d="m88.3 1c0.4 0.6 2.6 3.3 4.7 5.9 15.3 18.2 26.8 47.8 33 85.1 4.1 24.5 4.3 32.2 4.3 125.6v87h-41.8c-38.2 0-42.6-0.2-50.1-1.7-11.8-2.5-24-9.2-32.2-17.8-6.5-6.9-6.3-7.3-5.9 13.6 0.5 17.3 0.7 19.2 3.2 28.6 4 14.9 9.5 26 17.8 35.9 11.3 13.6 22.8 21.2 39.2 26.3 3.5 1 10.9 1.4 37.1 1.6l32.7 0.5v43.3 43.4l-46.1-0.3-46.3-0.3-8-3.2c-9.5-3.8-13.8-6.6-23.1-14.9l-6.8-6.1 0.4 19.1c0.5 17.7 0.6 19.7 3.1 28.7 8.7 31.8 29.7 54.5 57.4 61.9 6.9 1.9 9.6 2 38.5 2.4l30.9 0.4v89.6c0 54.1-0.3 94-0.8 100.8-0.5 6.2-2.1 17.8-3.5 25.9-6.5 37.3-18.2 65.4-35 83.6l-3.4 3.7h169.1c101.1 0 176.7-0.4 187.8-0.9 19.5-1 63-5.3 72.8-7.4 3.1-0.6 8.9-1.5 12.7-2.1 8.1-1.2 21.5-4 40.8-8.9 27.2-6.8 52-15.3 76.3-26.1 7.6-3.4 29.4-14.5 35.2-18 3.1-1.8 6.8-4 8.2-4.7 3.9-2.1 10.4-6.3 19.9-13.1 4.7-3.4 9.4-6.7 10.4-7.4 4.2-2.8 18.7-14.9 25.3-21 25.1-23.1 46.1-48.8 62.4-76.3 2.3-4 5.3-9 6.6-11.1 3.3-5.6 16.9-33.6 18.2-37.8 0.6-1.9 1.4-3.9 1.8-4.3 2.6-3.4 17.6-50.6 19.4-60.9 0.6-3.3 0.9-3.8 3.4-4.3 1.6-0.3 24.9-0.3 51.8-0.1 53.8 0.4 53.8 0.4 65.7 5.9 6.7 3.1 8.7 4.5 16.1 11.2 9.7 8.7 8.8 10.1 8.2-11.7-0.4-12.8-0.9-20.7-1.8-23.9-3.4-12.3-4.2-14.9-7.2-21.1-9.8-21.4-26.2-36.7-47.2-44l-8.2-3-33.4-0.4-33.3-0.5 0.4-11.7c0.4-15.4 0.4-45.9-0.1-61.6l-0.4-12.6 44.6-0.2c38.2-0.2 45.3 0 49.5 1.1 12.6 3.5 21.1 8.3 31.5 17.8l5.8 5.4v-14.8c0-17.6-0.9-25.4-4.5-37-7.1-23.5-21.1-41-41.1-51.8-13-7-13.8-7.2-58.5-7.5-26.2-0.2-39.9-0.6-40.6-1.2-0.6-0.6-1.1-1.6-1.1-2.4 0-0.8-1.5-7.1-3.5-13.9-23.4-82.7-67.1-148.4-131-197.1-8.7-6.7-30-20.8-38.6-25.6-3.3-1.9-6.9-3.9-7.8-4.5-4.2-2.3-28.3-14.1-34.3-16.6-3.6-1.6-8.3-3.6-10.4-4.4-35.3-15.3-94.5-29.8-139.7-34.3-7.4-0.7-17.2-1.8-21.7-2.2-20.4-2.3-48.7-2.6-209.4-2.6-135.8 0-169.9 0.3-169.4 1zm330.7 43.3c33.8 2 54.6 4.6 78.9 10.5 74.2 17.6 126.4 54.8 164.3 117 3.5 5.8 18.3 36 20.5 42.1 10.5 28.3 15.6 45.1 20.1 67.3 1.1 5.4 2.6 12.6 3.3 16 0.7 3.3 1 6.4 0.7 6.7-0.5 0.4-100.9 0.6-223.3 0.5l-222.5-0.2-0.3-128.5c-0.1-70.6 0-129.3 0.3-130.4l0.4-1.9h71.1c39 0 78 0.4 86.5 0.9zm297.5 350.3c0.7 4.3 0.7 77.3 0 80.9l-0.6 2.7-227.5-0.2-227.4-0.3-0.2-42.4c-0.2-23.3 0-42.7 0.2-43.1 0.3-0.5 97.2-0.8 227.7-0.8h227.2zm-10.2 171.7c0.5 1.5-1.9 13.8-6.8 33.8-5.6 22.5-13.2 45.2-20.9 62-3.8 8.6-13.3 27.2-15.6 30.7-1.1 1.6-4.3 6.7-7.1 11.2-18 28.2-43.7 53.9-73 72.9-10.7 6.8-32.7 18.4-38.6 20.2-1.2 0.3-2.5 0.9-3 1.3-0.7 0.6-9.8 4-20.4 7.8-19.5 6.9-56.6 14.4-86.4 17.5-19.3 1.9-22.4 2-96.7 2h-76.9v-129.7-129.8l220.9-0.4c121.5-0.2 221.6-0.5 222.4-0.7 0.9-0.1 1.8 0.5 2.1 1.2z"/>
                                    </svg>
                                </span>
                                <span class="warehouse-value-number">{{ is_numeric($value) ? number_format($value, 2) : str_replace(['د.إ ', 'د.إ'], '', $value) }}</span>
                            @else
                                <span class="warehouse-value-number">{{ is_numeric($value) ? number_format($value) : $value }}</span>
                            @endif
                        </h3>
                    </div>
                @endif
            </div>

            <!-- Action Arrow (if URL provided) -->
            @if($url && !$loading)
                <div class="warehouse-stat-action ml-1">
                    <i class="material-icons text-muted" style="font-size: 16px;">chevron_right</i>
                </div>
            @endif
        </div>

        <!-- Second Line: Title -->
        <div class="warehouse-stat-title">
            @if($loading)
                <div class="placeholder-glow">
                    <span class="placeholder col-8"></span>
                </div>
            @else
                <h6 class="mb-1 text-dark font-weight-medium warehouse-stat-title-text" style="font-size: 0.8rem;">{{ $title }}</h6>
            @endif
        </div>

        <!-- Third Line: Subtitle -->
        @if($subtitle && !$loading)
            <small class="text-muted d-block warehouse-stat-subtitle-text" style="font-size: 0.7rem; line-height: 1.2;">{{ $subtitle }}</small>
        @endif

        <!-- Trend -->
        @if($trend && !$loading)
            <div class="warehouse-stat-trend mt-1">
                <small class="text-{{ $trendDirection === 'up' ? 'success' : 'danger' }}">
                    <i class="material-icons" style="font-size: 12px; vertical-align: middle;">
                        {{ $trendDirection === 'up' ? 'trending_up' : 'trending_down' }}
                    </i>
                    {{ $trend }}
                </small>
            </div>
        @endif
    </div>

    @if($url)
        </a>
    @endif
</div>

