<!-- Warehouse Data Table Component -->
@props([
    'title' => '',
    'subtitle' => '',
    'columns' => [],
    'data' => [],
    'actions' => [],
    'filters' => [],
    'searchable' => true,
    'exportable' => true,
    'pagination' => null,
    'emptyMessage' => 'No data available',
    'loading' => false
])

<div class="warehouse-data-table card">
    <!-- Table Header -->
    <div class="card-header bg-white border-bottom">
        <div class="row align-items-center">
            <div class="col-md-6">
                @if($title)
                    <h5 class="card-title mb-0">{{ $title }}</h5>
                @endif
                @if($subtitle)
                    <p class="text-muted mb-0 mt-1">{{ $subtitle }}</p>
                @endif
            </div>
            <div class="col-md-6 text-right">
                <!-- Table Actions -->
                <div class="warehouse-table-actions">
                    @if($exportable)
                        <div class="btn-group mr-2">
                            <button type="button" class="btn btn-outline-secondary btn-sm dropdown-toggle" data-toggle="dropdown">
                                <i class="material-icons mr-1" style="font-size: 16px;">file_download</i>
                                Export
                            </button>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="#" onclick="exportTable('excel')">
                                    <i class="material-icons mr-2" style="font-size: 16px;">grid_on</i>
                                    Excel
                                </a>
                                <a class="dropdown-item" href="#" onclick="exportTable('csv')">
                                    <i class="material-icons mr-2" style="font-size: 16px;">description</i>
                                    CSV
                                </a>
                                <a class="dropdown-item" href="#" onclick="exportTable('pdf')">
                                    <i class="material-icons mr-2" style="font-size: 16px;">picture_as_pdf</i>
                                    PDF
                                </a>
                            </div>
                        </div>
                    @endif

                    @foreach($actions as $action)
                        <a href="{{ $action['url'] ?? '#' }}"
                           class="btn btn-{{ $action['color'] ?? 'primary' }} btn-sm mr-2"
                           @if(isset($action['onclick'])) onclick="{{ $action['onclick'] }}" @endif>
                            @if(isset($action['icon']))
                                <i class="material-icons mr-1" style="font-size: 16px;">{{ $action['icon'] }}</i>
                            @endif
                            {{ $action['label'] }}
                        </a>
                    @endforeach
                </div>
            </div>
        </div>

        <!-- Filters & Search -->
        @if($searchable || !empty($filters))
            <div class="row mt-3">
                @if($searchable)
                    <div class="col-md-4">
                        <div class="input-group input-group-sm">
                            <input type="text" class="form-control" placeholder="Search..." id="tableSearch">
                            <div class="input-group-append">
                                <button class="btn btn-outline-secondary" type="button">
                                    <i class="material-icons" style="font-size: 16px;">search</i>
                                </button>
                            </div>
                        </div>
                    </div>
                @endif

                @if(!empty($filters))
                    @foreach($filters as $filter)
                        <div class="col-md-2">
                            <select class="form-control form-control-sm table-filter" data-column="{{ $filter['column'] ?? '' }}">
                                <option value="">{{ $filter['placeholder'] ?? 'All' }}</option>
                                @foreach($filter['options'] ?? [] as $value => $label)
                                    <option value="{{ $value }}">{{ $label }}</option>
                                @endforeach
                            </select>
                        </div>
                    @endforeach
                @endif
            </div>
        @endif
    </div>

    <!-- Table Content -->
    <div class="table-responsive">
        @if($loading)
            <!-- Loading State -->
            <div class="text-center py-5">
                <div class="spinner-border text-primary" role="status">
                    <span class="sr-only">Loading...</span>
                </div>
                <p class="text-muted mt-2">Loading data...</p>
            </div>
        @elseif(empty($data) && !$loading)
            <!-- Empty State -->
            <div class="text-center py-5">
                <i class="material-icons text-muted mb-3" style="font-size: 48px;">inbox</i>
                <p class="text-muted">{{ $emptyMessage }}</p>
            </div>
        @else
            <!-- Data Table -->
            <table class="table table-hover mb-0" id="warehouseDataTable">
                <thead class="bg-light">
                    <tr>
                        @foreach($columns as $column)
                            <th class="{{ $column['class'] ?? '' }}"
                                @if($column['sortable'] ?? false) data-sortable="true" style="cursor: pointer;" @endif>
                                {{ $column['label'] }}
                                @if($column['sortable'] ?? false)
                                    <i class="material-icons float-right" style="font-size: 16px;">unfold_more</i>
                                @endif
                            </th>
                        @endforeach
                    </tr>
                </thead>
                <tbody>
                    {{ $slot }}
                </tbody>
            </table>
        @endif
    </div>

    <!-- Table Footer -->
    @if($pagination)
        <div class="card-footer bg-white border-top">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <small class="text-muted">
                        Showing {{ $pagination->firstItem() ?? 0 }} to {{ $pagination->lastItem() ?? 0 }}
                        of {{ $pagination->total() ?? 0 }} results
                    </small>
                </div>
                <div class="col-md-6">
                    {{ $pagination->links() }}
                </div>
            </div>
        </div>
    @endif
</div>

<style>
.warehouse-data-table {
    border: none;
    box-shadow: 0 2px 4px rgba(0,0,0,0.08);
    border-radius: 8px;
    overflow: hidden;
}

.warehouse-data-table .table th {
    border-top: none;
    font-weight: 600;
    font-size: 0.85rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    color: #495057;
}

.warehouse-data-table .table td {
    vertical-align: middle;
    font-size: 0.9rem;
}

.warehouse-data-table .table-hover tbody tr:hover {
    background-color: rgba(0,123,255,0.05);
}

.warehouse-table-actions .btn {
    border-radius: 4px;
}

.table th[data-sortable="true"]:hover {
    background-color: #e9ecef;
}

.table th[data-sortable="true"] .material-icons {
    opacity: 0.5;
    transition: opacity 0.2s ease;
}

.table th[data-sortable="true"]:hover .material-icons {
    opacity: 1;
}

@media (max-width: 768px) {
    .warehouse-table-actions {
        margin-top: 1rem;
    }

    .warehouse-table-actions .btn {
        margin-bottom: 0.5rem;
    }
}
</style>

<script>
function exportTable(format) {
    // Implementation for table export
    console.log('Export table in ' + format + ' format');
    // You can implement actual export functionality here
}

// Table search functionality
$(document).ready(function() {
    $('#tableSearch').on('keyup', function() {
        var value = $(this).val().toLowerCase();
        $('#warehouseDataTable tbody tr').filter(function() {
            $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
        });
    });

    // Table filter functionality
    $('.table-filter').on('change', function() {
        var column = $(this).data('column');
        var value = $(this).val().toLowerCase();

        $('#warehouseDataTable tbody tr').filter(function() {
            if (value === '') {
                $(this).show();
            } else {
                var cellText = $(this).find('td:eq(' + column + ')').text().toLowerCase();
                $(this).toggle(cellText.indexOf(value) > -1);
            }
        });
    });

    // Table sorting functionality
    $('th[data-sortable="true"]').on('click', function() {
        var table = $(this).parents('table').eq(0);
        var rows = table.find('tbody tr').toArray().sort(comparer($(this).index()));
        this.asc = !this.asc;
        if (!this.asc) {
            rows = rows.reverse();
        }
        table.find('tbody').empty().html(rows);

        // Update sort icon
        $('th .material-icons').text('unfold_more');
        $(this).find('.material-icons').text(this.asc ? 'keyboard_arrow_up' : 'keyboard_arrow_down');
    });
});

function comparer(index) {
    return function(a, b) {
        var valA = getCellValue(a, index);
        var valB = getCellValue(b, index);
        return $.isNumeric(valA) && $.isNumeric(valB) ? valA - valB : valA.toString().localeCompare(valB);
    };
}

function getCellValue(row, index) {
    return $(row).children('td').eq(index).text();
}
</script>