<!-- Delete User Modal -->
<div class="modal fade" id="deleteUserModal{{ $user->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteUserModalLabel{{ $user->id }}" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteUserModalLabel{{ $user->id }}">Delete User</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="text-center">
                    <i class="material-icons mb-3 text-danger" style="font-size: 48px;">warning</i>
                    <h5>Are you sure?</h5>
                    <p class="text-muted">You are about to delete the user:</p>
                    <div class="card border-left-danger shadow-sm mb-3">
                        <div class="card-body">
                            <div class="media align-items-center">
                                <img src="{{ $user->avatar_url }}" alt="{{ $user->full_name }}" class="avatar avatar-sm mr-3 rounded-circle">
                                <div class="media-body">
                                    <strong>{{ $user->full_name }}</strong>
                                    <div class="text-muted small">{{ $user->email }}</div>
                                    @if($user->employee_id)
                                        <div class="text-muted small">ID: {{ $user->employee_id }}</div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="alert alert-danger">
                        <p class="mb-0"><strong>Warning:</strong> This action cannot be undone.</p>
                        <ul class="mb-0 mt-2 text-left">
                            <li>User account will be permanently deleted</li>
                            <li>All user activities will be preserved for audit</li>
                            @if($user->avatar)
                                <li>User avatar will be deleted</li>
                            @endif
                        </ul>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-danger" onclick="deleteUser({{ $user->id }})">
                    <i class="material-icons mr-2">delete_forever</i>
                    Delete User
                </button>
            </div>
        </div>
    </div>
</div>

<script>
function deleteUser(userId) {
    const modal = document.getElementById('deleteUserModal' + userId);
    const deleteBtn = modal.querySelector('.btn-danger');
    const originalText = deleteBtn.innerHTML;
    
    // Show loading state
    deleteBtn.disabled = true;
    deleteBtn.innerHTML = '<i class="material-icons mr-2">hourglass_empty</i> Deleting...';
    
    fetch(`/admin/users/${userId}`, {
        method: 'DELETE',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'Content-Type': 'application/json',
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToastMessage(data.message, 'success');
            
            // Close modal and reload page
            $(modal).modal('hide');
            setTimeout(() => location.reload(), 1000);
        } else {
            showToastMessage(data.message || 'An error occurred', 'error');
            deleteBtn.disabled = false;
            deleteBtn.innerHTML = originalText;
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToastMessage('An error occurred while deleting the user', 'error');
        deleteBtn.disabled = false;
        deleteBtn.innerHTML = originalText;
    });
}
</script>