<?php
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(\Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = \Illuminate\Http\Request::capture()
);

use App\Models\DirectDelivery;
use App\Models\DirectDeliveryItem;
use App\Models\Warehouse\OutgoingFulfillment;

// Get direct delivery 5
$directDelivery = DirectDelivery::with('items')->find(5);

if ($directDelivery) {
    echo "Found direct delivery ID: " . $directDelivery->id . "\n";

    foreach ($directDelivery->items as $item) {
        // Check if fulfillment already exists
        $existing = OutgoingFulfillment::where('reference_type', 'DirectDelivery')
            ->where('reference_id', $directDelivery->id)
            ->where('item_id', $item->item_id)
            ->first();

        if (!$existing) {
            $fulfillment = OutgoingFulfillment::create([
                'outgoing_transaction_id' => 1, // Original transaction
                'item_id' => $item->item_id,
                'quantity_fulfilled' => $item->quantity_ordered,
                'fulfillment_type' => 'direct_delivery',
                'reference_id' => $directDelivery->id,
                'reference_type' => 'DirectDelivery',
                'notes' => 'Direct delivery fulfillment - retroactive'
            ]);
            echo "Created fulfillment for item " . $item->item_id . ": " . $item->quantity_ordered . " units\n";
        } else {
            echo "Fulfillment already exists for item " . $item->item_id . "\n";
        }
    }
} else {
    echo "Direct delivery not found.\n";
}