<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\VideoSetting;

class VideoSettingsSeeder extends Seeder
{
    public function run(): void
    {
        $videoSettings = [
            [
                'key' => 'hero_video',
                'title' => 'Hero Section Video',
                'description' => 'Main hero video for homepage',
                'video_type' => 'youtube',
                'video_url' => 'https://www.youtube.com/watch?v=dQw4w9WgXcQ', // Sample YouTube video
                'video_id' => 'dQw4w9WgXcQ',
                'thumbnail_url' => 'https://img.youtube.com/vi/dQw4w9WgXcQ/maxresdefault.jpg',
                'settings' => json_encode([
                    'autoplay' => true,
                    'mute' => true,
                    'loop' => true,
                    'controls' => false
                ]),
                'is_enabled' => true,
            ],
            [
                'key' => 'home_about_video',
                'title' => 'Home Page - What We Are Video',
                'description' => 'Video for What We Are section on homepage',
                'video_type' => 'youtube',
                'video_url' => 'https://www.youtube.com/watch?v=ScMzIvxBSi4', // Sample home about video
                'video_id' => 'ScMzIvxBSi4',
                'thumbnail_url' => 'https://img.youtube.com/vi/ScMzIvxBSi4/maxresdefault.jpg',
                'settings' => json_encode([
                    'autoplay' => false,
                    'mute' => false,
                    'loop' => false,
                    'controls' => true
                ]),
                'is_enabled' => true,
            ],
            [
                'key' => 'about_video',
                'title' => 'About Page - What We Are Video',
                'description' => 'Video for What We Are section on about page',
                'video_type' => 'youtube',
                'video_url' => 'https://www.youtube.com/watch?v=9bZkp7q19f0', // Sample about video
                'video_id' => '9bZkp7q19f0',
                'thumbnail_url' => 'https://img.youtube.com/vi/9bZkp7q19f0/maxresdefault.jpg',
                'settings' => json_encode([
                    'autoplay' => false,
                    'mute' => false,
                    'loop' => false,
                    'controls' => true
                ]),
                'is_enabled' => true,
            ],
        ];

        foreach ($videoSettings as $settingData) {
            VideoSetting::create($settingData);
        }
    }
}