<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UsersSeeder extends Seeder
{
    public function run(): void
    {
        $users = [
            // Admin Users
            [
                'name' => 'System Administrator',
                'first_name' => 'System',
                'last_name' => 'Administrator',
                'email' => 'admin@aufg.com',
                'email_verified_at' => now(),
                'password' => Hash::make('admin123'),
                'role_id' => 1,
                'phone' => '+1-555-0101',
                'department' => 'Administration',
                'employee_id' => 'ADMIN001',
                'avatar' => 'images/avatars/admin.jpg',
                'status' => 'active',
                'first_login' => false,
                'last_login_at' => now()->subHours(2),
            ],
            [
                'name' => 'Sarah Johnson',
                'first_name' => 'Sarah',
                'last_name' => 'Johnson',
                'email' => 'sarah.johnson@aufg.com',
                'email_verified_at' => now(),
                'password' => Hash::make('password123'),
                'role_id' => 1,
                'phone' => '+1-555-0102',
                'department' => 'Management',
                'employee_id' => 'ADMIN002',
                'avatar' => 'images/avatars/sarah.jpg',
                'status' => 'active',
                'first_login' => false,
                'last_login_at' => now()->subDays(1),
            ],

            // Regular Users
            [
                'name' => 'John Smith',
                'first_name' => 'John',
                'last_name' => 'Smith',
                'email' => 'john.smith@aufg.com',
                'email_verified_at' => now(),
                'password' => Hash::make('password123'),
                'role_id' => 2,
                'phone' => '+1-555-0201',
                'department' => 'Sales',
                'employee_id' => 'EMP001',
                'avatar' => 'images/avatars/john.jpg',
                'status' => 'active',
                'first_login' => false,
                'last_login_at' => now()->subHours(8),
            ],
            [
                'name' => 'Emily Chen',
                'first_name' => 'Emily',
                'last_name' => 'Chen',
                'email' => 'emily.chen@aufg.com',
                'email_verified_at' => now(),
                'password' => Hash::make('password123'),
                'role_id' => 2,
                'phone' => '+1-555-0202',
                'department' => 'Technical',
                'employee_id' => 'EMP002',
                'avatar' => 'images/avatars/emily.jpg',
                'status' => 'active',
                'first_login' => false,
                'last_login_at' => now()->subDays(2),
            ],
            [
                'name' => 'Michael Rodriguez',
                'first_name' => 'Michael',
                'last_name' => 'Rodriguez',
                'email' => 'michael.rodriguez@aufg.com',
                'email_verified_at' => now(),
                'password' => Hash::make('password123'),
                'role_id' => 2,
                'phone' => '+1-555-0203',
                'department' => 'Quality Control',
                'employee_id' => 'EMP003',
                'avatar' => 'images/avatars/michael.jpg',
                'status' => 'active',
                'first_login' => false,
                'last_login_at' => now()->subHours(4),
            ],
            [
                'name' => 'Lisa Wang',
                'first_name' => 'Lisa',
                'last_name' => 'Wang',
                'email' => 'lisa.wang@aufg.com',
                'email_verified_at' => now(),
                'password' => Hash::make('password123'),
                'role_id' => 2,
                'phone' => '+1-555-0204',
                'department' => 'Design',
                'employee_id' => 'EMP004',
                'avatar' => 'images/avatars/lisa.jpg',
                'status' => 'active',
                'first_login' => false,
                'last_login_at' => now()->subDays(3),
            ],
            [
                'name' => 'David Thompson',
                'first_name' => 'David',
                'last_name' => 'Thompson',
                'email' => 'david.thompson@aufg.com',
                'email_verified_at' => now(),
                'password' => Hash::make('password123'),
                'role_id' => 2,
                'phone' => '+1-555-0205',
                'department' => 'Production',
                'employee_id' => 'EMP005',
                'avatar' => 'images/avatars/david.jpg',
                'status' => 'active',
                'first_login' => false,
                'last_login_at' => now()->subHours(12),
            ],
            [
                'name' => 'Maria Garcia',
                'first_name' => 'Maria',
                'last_name' => 'Garcia',
                'email' => 'maria.garcia@aufg.com',
                'email_verified_at' => now(),
                'password' => Hash::make('password123'),
                'role_id' => 2,
                'phone' => '+1-555-0206',
                'department' => 'Customer Service',
                'employee_id' => 'EMP006',
                'avatar' => 'images/avatars/maria.jpg',
                'status' => 'active',
                'first_login' => false,
                'last_login_at' => now()->subDays(1),
            ],
            [
                'name' => 'Robert Kim',
                'first_name' => 'Robert',
                'last_name' => 'Kim',
                'email' => 'robert.kim@aufg.com',
                'email_verified_at' => now(),
                'password' => Hash::make('password123'),
                'role_id' => 2,
                'phone' => '+1-555-0207',
                'department' => 'R&D',
                'employee_id' => 'EMP007',
                'avatar' => 'images/avatars/robert.jpg',
                'status' => 'active',
                'first_login' => false,
                'last_login_at' => now()->subHours(6),
            ],
            [
                'name' => 'Jennifer Brown',
                'first_name' => 'Jennifer',
                'last_name' => 'Brown',
                'email' => 'jennifer.brown@aufg.com',
                'email_verified_at' => now(),
                'password' => Hash::make('password123'),
                'role_id' => 2,
                'phone' => '+1-555-0208',
                'department' => 'Marketing',
                'employee_id' => 'EMP008',
                'avatar' => 'images/avatars/jennifer.jpg',
                'status' => 'active',
                'first_login' => false,
                'last_login_at' => now()->subDays(4),
            ],

            // Test Users
            [
                'name' => 'Test User',
                'first_name' => 'Test',
                'last_name' => 'User',
                'email' => 'test@example.com',
                'email_verified_at' => now(),
                'password' => Hash::make('password'),
                'role_id' => 2,
                'phone' => '+1-555-9999',
                'department' => 'Testing',
                'employee_id' => 'TEST001',
                'avatar' => 'images/avatars/test.jpg',
                'status' => 'active',
                'first_login' => false,
                'last_login_at' => now()->subMinutes(30),
            ],
        ];

        foreach ($users as $userData) {
            User::create($userData);
        }
    }
}