<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\SiteSetting;

class SiteSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            // Contact Settings
            [
                'key' => 'contact_phone',
                'value' => '+966 556 003 206',
                'type' => 'phone',
                'group' => 'contact',
                'label' => 'Contact Phone Number',
                'description' => 'Main contact phone number displayed in footer and contact page',
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'key' => 'contact_phone_raw',
                'value' => '966556003206',
                'type' => 'phone',
                'group' => 'contact',
                'label' => 'Contact Phone (Raw)',
                'description' => 'Raw phone number for tel: links (without spaces or special chars)',
                'is_active' => true,
                'sort_order' => 2
            ],
            [
                'key' => 'contact_email',
                'value' => 'info@aufgc.com',
                'type' => 'email',
                'group' => 'contact',
                'label' => 'Contact Email',
                'description' => 'Main contact email displayed in footer and contact page',
                'is_active' => true,
                'sort_order' => 3
            ],
            
            // WhatsApp Settings
            [
                'key' => 'whatsapp_number',
                'value' => '966556003206',
                'type' => 'phone',
                'group' => 'whatsapp',
                'label' => 'WhatsApp Number',
                'description' => 'WhatsApp number for floating button and contact',
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'key' => 'whatsapp_message',
                'value' => 'Hello, I\'m interested in your services',
                'type' => 'text',
                'group' => 'whatsapp',
                'label' => 'WhatsApp Default Message',
                'description' => 'Default message for WhatsApp chat',
                'is_active' => true,
                'sort_order' => 2
            ],
            
            // Social Media Settings
            [
                'key' => 'social_facebook_url',
                'value' => 'https://www.facebook.com/aufgc',
                'type' => 'url',
                'group' => 'social',
                'label' => 'Facebook URL',
                'description' => 'Official Facebook page URL',
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'key' => 'social_linkedin_url',
                'value' => 'https://www.linkedin.com/company/aufgc',
                'type' => 'url',
                'group' => 'social',
                'label' => 'LinkedIn URL',
                'description' => 'Official LinkedIn company page URL',
                'is_active' => true,
                'sort_order' => 2
            ],
            [
                'key' => 'social_twitter_url',
                'value' => 'https://x.com/aufgc',
                'type' => 'url',
                'group' => 'social',
                'label' => 'Twitter/X URL',
                'description' => 'Official Twitter/X page URL',
                'is_active' => true,
                'sort_order' => 3
            ],
            [
                'key' => 'social_instagram_url',
                'value' => 'https://www.instagram.com/aufgc',
                'type' => 'url',
                'group' => 'social',
                'label' => 'Instagram URL',
                'description' => 'Official Instagram page URL',
                'is_active' => true,
                'sort_order' => 4
            ],
            
            // General Settings
            [
                'key' => 'site_name',
                'value' => 'Arabian United Float Glass Company (UFG)',
                'type' => 'text',
                'group' => 'general',
                'label' => 'Site Name',
                'description' => 'Company name used throughout the site',
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'key' => 'company_short_name',
                'value' => 'UFG',
                'type' => 'text',
                'group' => 'general',
                'label' => 'Company Short Name',
                'description' => 'Short company name/abbreviation',
                'is_active' => true,
                'sort_order' => 2
            ],
            [
                'key' => 'copyright_text',
                'value' => 'Arabian United Float Glass Company (UFG) All rights reserved',
                'type' => 'text',
                'group' => 'general',
                'label' => 'Copyright Text',
                'description' => 'Copyright text displayed in footer',
                'is_active' => true,
                'sort_order' => 3
            ],
            [
                'key' => 'company_address',
                'value' => 'Riyadh, Saudi Arabia',
                'type' => 'textarea',
                'group' => 'contact',
                'label' => 'Company Address',
                'description' => 'Company physical address',
                'is_active' => true,
                'sort_order' => 4
            ],
            
            // Logo & Branding Settings
            [
                'key' => 'site_logo',
                'value' => 'images/aufg-logo.png',
                'type' => 'file',
                'group' => 'general',
                'label' => 'Site Logo',
                'description' => 'Main logo used in header and footer',
                'is_active' => true,
                'sort_order' => 4
            ],
            [
                'key' => 'admin_logo',
                'value' => 'assets/images/admin-logo.svg',
                'type' => 'file',
                'group' => 'general',
                'label' => 'Admin Panel Logo',
                'description' => 'Logo displayed in admin panel header',
                'is_active' => true,
                'sort_order' => 5
            ],
            [
                'key' => 'favicon',
                'value' => 'favicon.ico',
                'type' => 'file',
                'group' => 'general',
                'label' => 'Favicon',
                'description' => 'Website favicon (ICO format recommended)',
                'is_active' => true,
                'sort_order' => 6
            ]
        ];

        foreach ($settings as $setting) {
            SiteSetting::updateOrCreate(
                ['key' => $setting['key']],
                $setting
            );
        }
    }
}
