<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\Role;
use Illuminate\Database\Seeder;

class PermissionsSeeder extends Seeder
{
    public function run(): void
    {
        $permissions = [
            // User Management
            ['name' => 'view_users', 'display_name' => 'View Users', 'description' => 'Can view user list'],
            ['name' => 'create_users', 'display_name' => 'Create Users', 'description' => 'Can create new users'],
            ['name' => 'edit_users', 'display_name' => 'Edit Users', 'description' => 'Can edit user information'],
            ['name' => 'delete_users', 'display_name' => 'Delete Users', 'description' => 'Can delete users'],
            
            // Role Management
            ['name' => 'manage_roles', 'display_name' => 'Manage Roles', 'description' => 'Can manage roles and permissions'],
            ['name' => 'view_roles', 'display_name' => 'View Roles', 'description' => 'Can view roles'],
            ['name' => 'create_roles', 'display_name' => 'Create Roles', 'description' => 'Can create new roles'],
            ['name' => 'edit_roles', 'display_name' => 'Edit Roles', 'description' => 'Can edit roles'],
            ['name' => 'delete_roles', 'display_name' => 'Delete Roles', 'description' => 'Can delete roles'],
            
            // Department Management
            ['name' => 'manage_departments', 'display_name' => 'Manage Departments', 'description' => 'Can manage departments'],
            ['name' => 'view_departments', 'display_name' => 'View Departments', 'description' => 'Can view departments'],
            
            // Activity Logs
            ['name' => 'view_activity_logs', 'display_name' => 'View Activity Logs', 'description' => 'Can view system activity logs'],
            
            // News Management
            ['name' => 'view_news', 'display_name' => 'View News', 'description' => 'Can view news articles'],
            ['name' => 'create_news', 'display_name' => 'Create News', 'description' => 'Can create news articles'],
            ['name' => 'edit_news', 'display_name' => 'Edit News', 'description' => 'Can edit news articles'],
            ['name' => 'delete_news', 'display_name' => 'Delete News', 'description' => 'Can delete news articles'],
            ['name' => 'publish_news', 'display_name' => 'Publish News', 'description' => 'Can publish/unpublish news'],
            
            // Video Management
            ['name' => 'view_videos', 'display_name' => 'View Videos', 'description' => 'Can view videos'],
            ['name' => 'create_videos', 'display_name' => 'Create Videos', 'description' => 'Can create videos'],
            ['name' => 'edit_videos', 'display_name' => 'Edit Videos', 'description' => 'Can edit videos'],
            ['name' => 'delete_videos', 'display_name' => 'Delete Videos', 'description' => 'Can delete videos'],
            
            // Product Management
            ['name' => 'view_products', 'display_name' => 'View Products', 'description' => 'Can view products'],
            ['name' => 'create_products', 'display_name' => 'Create Products', 'description' => 'Can create products'],
            ['name' => 'edit_products', 'display_name' => 'Edit Products', 'description' => 'Can edit products'],
            ['name' => 'delete_products', 'display_name' => 'Delete Products', 'description' => 'Can delete products'],
            
            // Category Management
            ['name' => 'view_categories', 'display_name' => 'View Categories', 'description' => 'Can view categories'],
            ['name' => 'create_categories', 'display_name' => 'Create Categories', 'description' => 'Can create categories'],
            ['name' => 'edit_categories', 'display_name' => 'Edit Categories', 'description' => 'Can edit categories'],
            ['name' => 'delete_categories', 'display_name' => 'Delete Categories', 'description' => 'Can delete categories'],
            
            // Reports Management
            ['name' => 'view_reports', 'display_name' => 'View Reports', 'description' => 'Can view reports'],
            ['name' => 'create_reports', 'display_name' => 'Create Reports', 'description' => 'Can create reports'],
            ['name' => 'edit_reports', 'display_name' => 'Edit Reports', 'description' => 'Can edit reports'],
            ['name' => 'delete_reports', 'display_name' => 'Delete Reports', 'description' => 'Can delete reports'],
            
            // Pages Management
            ['name' => 'view_pages', 'display_name' => 'View Pages', 'description' => 'Can view pages'],
            ['name' => 'create_pages', 'display_name' => 'Create Pages', 'description' => 'Can create pages'],
            ['name' => 'edit_pages', 'display_name' => 'Edit Pages', 'description' => 'Can edit pages'],
            ['name' => 'delete_pages', 'display_name' => 'Delete Pages', 'description' => 'Can delete pages'],
            
            // Careers Management
            ['name' => 'view_careers', 'display_name' => 'View Careers', 'description' => 'Can view career-related data'],
            ['name' => 'manage_careers', 'display_name' => 'Manage Careers', 'description' => 'Can manage job positions and applications'],
            
            // Inquiries Management
            ['name' => 'view_inquiries', 'display_name' => 'View Inquiries', 'description' => 'Can view contact and investor inquiries'],
            ['name' => 'manage_inquiries', 'display_name' => 'Manage Inquiries', 'description' => 'Can manage inquiries'],
            
            // Team Management
            ['name' => 'view_team', 'display_name' => 'View Team', 'description' => 'Can view team members'],
            ['name' => 'manage_team', 'display_name' => 'Manage Team', 'description' => 'Can manage team members'],
            
            // Site Settings
            ['name' => 'manage_settings', 'display_name' => 'Manage Settings', 'description' => 'Can manage site settings'],
            ['name' => 'view_settings', 'display_name' => 'View Settings', 'description' => 'Can view site settings'],
            
            // Admin Panel Access
            ['name' => 'access_admin_dashboard', 'display_name' => 'Access Admin Dashboard', 'description' => 'Can access the admin panel and dashboard'],
            
            // Full Management Permissions
            ['name' => 'manage_news', 'display_name' => 'Manage News', 'description' => 'Full access to news management'],
            ['name' => 'manage_videos', 'display_name' => 'Manage Videos', 'description' => 'Full access to video management'],
            ['name' => 'manage_products', 'display_name' => 'Manage Products', 'description' => 'Full access to product management'],
            ['name' => 'manage_pages', 'display_name' => 'Manage Pages', 'description' => 'Full access to page management'],
            ['name' => 'manage_users', 'display_name' => 'Manage Users', 'description' => 'Full access to user management'],
            ['name' => 'manage_activity_logs', 'display_name' => 'Manage Activity Logs', 'description' => 'Full access to activity logs'],
            ['name' => 'full_access', 'display_name' => 'Full System Access', 'description' => 'Complete administrative access to all features'],
        ];

        // Create permissions
        foreach ($permissions as $permissionData) {
            Permission::create($permissionData);
        }

        // Assign all permissions to admin role
        $adminRole = Role::where('name', 'admin')->first();
        if ($adminRole) {
            $permissionIds = Permission::pluck('id')->toArray();
            $adminRole->permissions()->sync($permissionIds);
        }

        // Give basic permissions to regular users
        $userRole = Role::where('name', 'user')->first();
        if ($userRole) {
            $basicPermissions = Permission::whereIn('name', [
                'view_news',
                'view_videos', 
                'view_products',
                'view_pages'
            ])->pluck('id')->toArray();
            $userRole->permissions()->sync($basicPermissions);
        }
    }
}