<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ItemCategorySeeder extends Seeder
{
    public function run(): void
    {
        $categories = [
            [
                'category_name' => 'Construction Materials',
                'type_of_goods' => 'Raw Materials',
                'description' => 'Basic construction materials like cement, steel, concrete',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'category_name' => 'Electrical Equipment',
                'type_of_goods' => 'Equipment',
                'description' => 'Electrical components, wiring, and electrical tools',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'category_name' => 'Plumbing Supplies',
                'type_of_goods' => 'Raw Materials',
                'description' => 'Pipes, fittings, valves, and plumbing fixtures',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'category_name' => 'Safety Equipment',
                'type_of_goods' => 'Safety',
                'description' => 'Personal protective equipment and safety gear',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'category_name' => 'Tools & Hardware',
                'type_of_goods' => 'Tools',
                'description' => 'Hand tools, power tools, and hardware items',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'category_name' => 'Fasteners',
                'type_of_goods' => 'Hardware',
                'description' => 'Screws, bolts, nuts, washers, and anchors',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'category_name' => 'Paints & Coatings',
                'type_of_goods' => 'Chemicals',
                'description' => 'Paints, primers, sealers, and protective coatings',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'category_name' => 'HVAC Equipment',
                'type_of_goods' => 'Equipment',
                'description' => 'Heating, ventilation, and air conditioning equipment',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'category_name' => 'Roofing Materials',
                'type_of_goods' => 'Raw Materials',
                'description' => 'Shingles, tiles, membranes, and roofing accessories',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'category_name' => 'Flooring Materials',
                'type_of_goods' => 'Finishes',
                'description' => 'Tiles, carpets, hardwood, and flooring accessories',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        DB::table('item_categories')->insert($categories);
    }
}