<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;

class AdditionalPagesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $additionalPages = [
            [
                'title' => 'Products',
                'slug' => 'products',
                'route_name' => 'products',
                'template' => 'products',
                'meta_description' => 'Explore our comprehensive range of high-quality float glass products',
                'meta_keywords' => 'float glass, architectural glass, automotive glass, glass products',
                'is_enabled' => true,
                'show_in_nav' => true,
                'sort_order' => 3,
                'content_sections' => [
                    'hero' => [
                        'title' => 'Our Products',
                        'content' => 'Premium glass solutions for every need',
                        'type' => 'hero',
                        'order' => 1,
                        'is_enabled' => true,
                        'settings' => []
                    ]
                ]
            ],
            [
                'title' => 'Investors',
                'slug' => 'investors',
                'route_name' => 'investors',
                'template' => 'investors',
                'meta_description' => 'Investor relations, financial reports, and corporate governance',
                'meta_keywords' => 'investor relations, financial reports, corporate governance, UFG investors',
                'is_enabled' => true,
                'show_in_nav' => true,
                'sort_order' => 5,
                'content_sections' => [
                    'hero' => [
                        'title' => 'Investor Relations',
                        'content' => 'Building trust through transparency',
                        'type' => 'hero',
                        'order' => 1,
                        'is_enabled' => true,
                        'settings' => []
                    ]
                ]
            ],
            [
                'title' => 'Careers',
                'slug' => 'careers',
                'route_name' => 'careers',
                'template' => 'careers',
                'meta_description' => 'Join our team and build your career with UFG',
                'meta_keywords' => 'careers, jobs, employment, UFG careers',
                'is_enabled' => true,
                'show_in_nav' => true,
                'sort_order' => 7,
                'content_sections' => [
                    'hero' => [
                        'title' => 'Careers at UFG',
                        'content' => 'Shape your future with us',
                        'type' => 'hero',
                        'order' => 1,
                        'is_enabled' => true,
                        'settings' => []
                    ]
                ]
            ],
            [
                'title' => 'News',
                'slug' => 'news',
                'route_name' => 'news',
                'template' => 'news',
                'meta_description' => 'Latest news, updates, and announcements from UFG',
                'meta_keywords' => 'news, updates, announcements, UFG news',
                'is_enabled' => true,
                'show_in_nav' => false,
                'sort_order' => 8,
                'content_sections' => [
                    'hero' => [
                        'title' => 'News & Updates',
                        'content' => 'Stay informed about our latest developments',
                        'type' => 'hero',
                        'order' => 1,
                        'is_enabled' => true,
                        'settings' => []
                    ]
                ]
            ],
            [
                'title' => 'Videos',
                'slug' => 'videos',
                'route_name' => 'videos',
                'template' => 'videos',
                'meta_description' => 'Watch videos about our products, processes, and company',
                'meta_keywords' => 'videos, multimedia, UFG videos',
                'is_enabled' => true,
                'show_in_nav' => false,
                'sort_order' => 9,
                'content_sections' => [
                    'hero' => [
                        'title' => 'Video Gallery',
                        'content' => 'Discover our story through video',
                        'type' => 'hero',
                        'order' => 1,
                        'is_enabled' => true,
                        'settings' => []
                    ]
                ]
            ]
        ];

        foreach ($additionalPages as $pageData) {
            Page::updateOrCreate(
                ['slug' => $pageData['slug']],
                $pageData
            );
        }

        $this->command->info('Additional pages seeded successfully!');
    }
}