<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('outgoing_items', function (Blueprint $table) {
            $table->foreignId('division_id')->nullable()->after('item_id')->constrained('departments')->onDelete('restrict');
            $table->index(['item_id', 'division_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('outgoing_items', function (Blueprint $table) {
            $table->dropForeign(['division_id']);
            $table->dropIndex(['item_id', 'division_id']);
            $table->dropColumn('division_id');
        });
    }
};