<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('incoming_operation_items', function (Blueprint $table) {
            $table->unsignedBigInteger('outgoing_fulfillment_id')->nullable()->after('supplier_delivery_item_id');
            $table->foreign('outgoing_fulfillment_id')->references('id')->on('outgoing_fulfillments')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('incoming_operation_items', function (Blueprint $table) {
            $table->dropForeign(['outgoing_fulfillment_id']);
            $table->dropColumn('outgoing_fulfillment_id');
        });
    }
};
