<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // For MySQL, we need to use raw SQL to modify ENUM columns
        DB::statement("ALTER TABLE outgoing_fulfillments MODIFY COLUMN fulfillment_type ENUM('inventory', 'direct_delivery', 'project_transfer', 'foc_transfer', 'inventory_dispatch') NOT NULL");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert back to original enum values
        // First, update any foc_transfer records to inventory_dispatch for rollback compatibility
        DB::statement("UPDATE outgoing_fulfillments SET fulfillment_type = 'inventory' WHERE fulfillment_type IN ('foc_transfer', 'inventory_dispatch')");

        // Then modify the column back to original enum
        DB::statement("ALTER TABLE outgoing_fulfillments MODIFY COLUMN fulfillment_type ENUM('inventory', 'direct_delivery', 'project_transfer') NOT NULL");
    }
};
