<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('incoming_operations', function (Blueprint $table) {
            $table->string('delivery_type')->default('warehouse')->after('delivery_file');
            $table->text('delivery_address')->nullable()->after('delivery_type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('incoming_operations', function (Blueprint $table) {
            $table->dropColumn(['delivery_type', 'delivery_address']);
        });
    }
};
