<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('material_site_transfers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('from_project_id')->constrained('projects')->onDelete('restrict');
            $table->foreignId('to_project_id')->constrained('projects')->onDelete('restrict');
            $table->date('transfer_date');
            $table->text('notes')->nullable();
            $table->foreignId('transferred_by')->constrained('users')->onDelete('restrict');
            $table->enum('status', ['pending', 'completed', 'cancelled'])->default('completed');
            $table->decimal('total_value', 15, 2)->default(0);
            $table->timestamps();
            $table->softDeletes();

            // Indexes
            $table->index(['from_project_id', 'transfer_date']);
            $table->index(['to_project_id', 'transfer_date']);
            $table->index(['status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('material_site_transfers');
    }
};