<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('material_transfer_request_items', function (Blueprint $table) {
            $table->unsignedBigInteger('outgoing_item_id')->nullable()->after('item_id');
            $table->unsignedBigInteger('direct_delivery_item_id')->nullable()->after('outgoing_item_id');

            $table->foreign('outgoing_item_id')->references('id')->on('outgoing_items')->onDelete('set null');
            $table->foreign('direct_delivery_item_id')->references('id')->on('direct_delivery_items')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('material_transfer_request_items', function (Blueprint $table) {
            $table->dropForeign(['outgoing_item_id']);
            $table->dropForeign(['direct_delivery_item_id']);
            $table->dropColumn(['outgoing_item_id', 'direct_delivery_item_id']);
        });
    }
};
