<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('direct_delivery_items', function (Blueprint $table) {
            // Add default values to all price and currency related fields
            if (Schema::hasColumn('direct_delivery_items', 'unit_price_aed')) {
                $table->decimal('unit_price_aed', 10, 2)->default(0)->change();
            }
            if (Schema::hasColumn('direct_delivery_items', 'total_price_aed')) {
                $table->decimal('total_price_aed', 15, 2)->default(0)->change();
            }
            if (Schema::hasColumn('direct_delivery_items', 'currency')) {
                $table->enum('currency', ['AED', 'USD', 'EUR'])->default('AED')->change();
            }

            // Set other fields to have appropriate defaults
            $table->decimal('tax_rate', 5, 2)->default(0)->change();
            $table->decimal('tax_amount', 10, 2)->default(0)->change();
            $table->decimal('discount_rate', 5, 2)->default(0)->change();
            $table->decimal('discount_amount', 10, 2)->default(0)->change();

            // Make text fields nullable
            $table->string('batch_number')->nullable()->change();
            $table->string('serial_number')->nullable()->change();
            $table->date('manufacturing_date')->nullable()->change();
            $table->date('expiry_date')->nullable()->change();
            $table->string('manufacturer')->nullable()->change();
            $table->string('country_of_origin')->nullable()->change();
            $table->string('item_description')->nullable()->change();
            $table->text('specifications')->nullable()->change();
            $table->text('quality_notes')->nullable()->change();
            $table->json('quality_checklist')->nullable()->change();
            $table->string('storage_location')->nullable()->change();
            $table->string('storage_conditions')->nullable()->change();
            $table->json('hazard_classifications')->nullable()->change();
            $table->string('project_phase')->nullable()->change();
            $table->string('work_area')->nullable()->change();
            $table->string('rack_number')->nullable()->change();
            $table->string('bin_number')->nullable()->change();
            $table->text('receipt_notes')->nullable()->change();
            $table->text('rejection_reason')->nullable()->change();

            // Set default values for other fields
            if (Schema::hasColumn('direct_delivery_items', 'hazardous_material')) {
                $table->boolean('hazardous_material')->default(false)->change();
            }
            if (Schema::hasColumn('direct_delivery_items', 'requires_maintenance')) {
                $table->boolean('requires_maintenance')->default(false)->change();
            }
            if (Schema::hasColumn('direct_delivery_items', 'can_be_returned')) {
                $table->boolean('can_be_returned')->default(true)->change();
            }
            if (Schema::hasColumn('direct_delivery_items', 'status')) {
                $table->enum('status', ['pending', 'delivered', 'accepted', 'rejected', 'returned'])->default('pending')->change();
            }

            // Set default for quality_status
            $table->enum('quality_status', ['pending', 'passed', 'failed', 'partial'])->default('pending')->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('direct_delivery_items', function (Blueprint $table) {
            // This rollback would be complex and might break data, so we'll keep it minimal
            // In a production environment, you'd want to be more careful about rollbacks
        });
    }
};