<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('direct_deliveries', function (Blueprint $table) {
            // Make supplier_id nullable since it will be filled later by admin
            $table->foreignId('supplier_id')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('direct_deliveries', function (Blueprint $table) {
            // Revert supplier_id back to not nullable (if needed)
            $table->foreignId('supplier_id')->nullable(false)->change();
        });
    }
};