<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_activities', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('action'); // e.g., 'login', 'logout', 'create_user', 'update_profile'
            $table->text('description')->nullable(); // Detailed description of the action
            $table->json('properties')->nullable(); // Additional data about the action
            $table->string('ip_address')->nullable();
            $table->text('user_agent')->nullable();
            $table->string('subject_type')->nullable(); // Model class name if action was on a model
            $table->unsignedBigInteger('subject_id')->nullable(); // Model ID if action was on a model
            $table->timestamps();
            
            // Indexes for performance
            $table->index(['user_id', 'created_at']);
            $table->index(['action', 'created_at']);
            $table->index(['subject_type', 'subject_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_activities');
    }
};
