-- WARNING: This will delete ALL data from items and item_categories tables
-- Use with caution - this removes both seed and user data

-- Disable foreign key checks temporarily
SET FOREIGN_KEY_CHECKS = 0;

-- Delete all items first (due to foreign key constraints)
DELETE FROM items;

-- Delete all item categories
DELETE FROM item_categories;

-- Re-enable foreign key checks
SET FOREIGN_KEY_CHECKS = 1;

-- Reset auto-increment counters
ALTER TABLE items AUTO_INCREMENT = 1;
ALTER TABLE item_categories AUTO_INCREMENT = 1;

-- Verify the cleanup
SELECT COUNT(*) as items_count FROM items;
SELECT COUNT(*) as categories_count FROM item_categories;