<?php

namespace App\Models\Warehouse;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class OutgoingFulfillment extends Model
{
    use HasFactory;

    protected $fillable = [
        'outgoing_transaction_id',
        'item_id',
        'quantity_fulfilled',
        'fulfillment_type',
        'reference_id',
        'reference_type',
        'notes'
    ];

    protected $casts = [
        'quantity_fulfilled' => 'decimal:2',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    /**
     * Get the outgoing transaction
     */
    public function outgoingTransaction(): BelongsTo
    {
        return $this->belongsTo(OutgoingTransaction::class);
    }

    /**
     * Get the item
     */
    public function item(): BelongsTo
    {
        return $this->belongsTo(Item::class);
    }
}