<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Job extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'description', 
        'location',
        'experience',
        'tags',
        'type',
        'is_active',
        'posted_at'
    ];

    protected $casts = [
        'tags' => 'array',
        'is_active' => 'boolean',
        'posted_at' => 'datetime'
    ];

    // Scope for active jobs
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    // Scope for recent jobs
    public function scopeRecent($query)
    {
        return $query->orderBy('posted_at', 'desc');
    }
}
