<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;
use App\Services\Auth\RoleBasedAccessService;

class WarehouseAccessMiddleware
{
    protected $accessService;

    public function __construct(RoleBasedAccessService $accessService)
    {
        $this->accessService = $accessService;
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Check if user is authenticated
        if (!Auth::check()) {
            return redirect()->route('admin.login');
        }

        $user = Auth::user();

        // Check if user has warehouse access using the service
        if (!$this->accessService->hasWarehouseAccess($user)) {
            abort(403, 'You do not have permission to access the warehouse system.');
        }

        return $next($request);
    }
}